/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgentAsync;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommand;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecution;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecutionSummary;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandSummary;
import com.oracle.bmc.computeinstanceagent.requests.CancelInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.CreateInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandExecutionRequest;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandExecutionsRequest;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentCommandsRequest;
import com.oracle.bmc.computeinstanceagent.responses.CancelInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.CreateInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandExecutionsResponse;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentCommandsResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeInstanceAgentAsyncClient
extends BaseAsyncClient
implements ComputeInstanceAgentAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEINSTANCEAGENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ComputeInstanceAgentAsyncClient.class);

    private ComputeInstanceAgentAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelInstanceAgentCommandResponse> cancelInstanceAgentCommand(CancelInstanceAgentCommandRequest request, AsyncHandler<CancelInstanceAgentCommandRequest, CancelInstanceAgentCommandResponse> handler) {
        Validate.notBlank((String)request.getInstanceAgentCommandId(), (String)"instanceAgentCommandId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelInstanceAgentCommandResponse::builder).logger(LOG, "cancelInstanceAgentCommand").serviceDetails("ComputeInstanceAgent", "CancelInstanceAgentCommand", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/InstanceAgentCommand/CancelInstanceAgentCommand").method(Method.DELETE).requestBuilder(CancelInstanceAgentCommandRequest::builder).basePath("/20180530").appendPathParam("instanceAgentCommands").appendPathParam(request.getInstanceAgentCommandId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelInstanceAgentCommandResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateInstanceAgentCommandResponse> createInstanceAgentCommand(CreateInstanceAgentCommandRequest request, AsyncHandler<CreateInstanceAgentCommandRequest, CreateInstanceAgentCommandResponse> handler) {
        Objects.requireNonNull(request.getCreateInstanceAgentCommandDetails(), "createInstanceAgentCommandDetails is required");
        return this.clientCall(request, CreateInstanceAgentCommandResponse::builder).logger(LOG, "createInstanceAgentCommand").serviceDetails("ComputeInstanceAgent", "CreateInstanceAgentCommand", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/InstanceAgentCommand/CreateInstanceAgentCommand").method(Method.POST).requestBuilder(CreateInstanceAgentCommandRequest::builder).basePath("/20180530").appendPathParam("instanceAgentCommands").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InstanceAgentCommand.class, CreateInstanceAgentCommandResponse.Builder::instanceAgentCommand).handleResponseHeaderString("etag", CreateInstanceAgentCommandResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateInstanceAgentCommandResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstanceAgentCommandResponse> getInstanceAgentCommand(GetInstanceAgentCommandRequest request, AsyncHandler<GetInstanceAgentCommandRequest, GetInstanceAgentCommandResponse> handler) {
        Validate.notBlank((String)request.getInstanceAgentCommandId(), (String)"instanceAgentCommandId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstanceAgentCommandResponse::builder).logger(LOG, "getInstanceAgentCommand").serviceDetails("ComputeInstanceAgent", "GetInstanceAgentCommand", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/InstanceAgentCommand/GetInstanceAgentCommand").method(Method.GET).requestBuilder(GetInstanceAgentCommandRequest::builder).basePath("/20180530").appendPathParam("instanceAgentCommands").appendPathParam(request.getInstanceAgentCommandId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstanceAgentCommand.class, GetInstanceAgentCommandResponse.Builder::instanceAgentCommand).handleResponseHeaderString("etag", GetInstanceAgentCommandResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstanceAgentCommandResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstanceAgentCommandExecutionResponse> getInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request, AsyncHandler<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> handler) {
        Validate.notBlank((String)request.getInstanceAgentCommandId(), (String)"instanceAgentCommandId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstanceId(), "instanceId is required");
        return this.clientCall(request, GetInstanceAgentCommandExecutionResponse::builder).logger(LOG, "getInstanceAgentCommandExecution").serviceDetails("ComputeInstanceAgent", "GetInstanceAgentCommandExecution", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/InstanceAgentCommandExecution/GetInstanceAgentCommandExecution").method(Method.GET).requestBuilder(GetInstanceAgentCommandExecutionRequest::builder).basePath("/20180530").appendPathParam("instanceAgentCommands").appendPathParam(request.getInstanceAgentCommandId()).appendPathParam("status").appendQueryParam("instanceId", (Object)request.getInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstanceAgentCommandExecution.class, GetInstanceAgentCommandExecutionResponse.Builder::instanceAgentCommandExecution).handleResponseHeaderString("etag", GetInstanceAgentCommandExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstanceAgentCommandExecutionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstanceAgentCommandExecutionsResponse> listInstanceAgentCommandExecutions(ListInstanceAgentCommandExecutionsRequest request, AsyncHandler<ListInstanceAgentCommandExecutionsRequest, ListInstanceAgentCommandExecutionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getInstanceId(), "instanceId is required");
        return this.clientCall(request, ListInstanceAgentCommandExecutionsResponse::builder).logger(LOG, "listInstanceAgentCommandExecutions").serviceDetails("ComputeInstanceAgent", "ListInstanceAgentCommandExecutions", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/InstanceAgentCommandExecutionSummary/ListInstanceAgentCommandExecutions").method(Method.GET).requestBuilder(ListInstanceAgentCommandExecutionsRequest::builder).basePath("/20180530").appendPathParam("instanceAgentCommandExecutions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstanceAgentCommandExecutionSummary.class, ListInstanceAgentCommandExecutionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceAgentCommandExecutionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceAgentCommandExecutionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstanceAgentCommandsResponse> listInstanceAgentCommands(ListInstanceAgentCommandsRequest request, AsyncHandler<ListInstanceAgentCommandsRequest, ListInstanceAgentCommandsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInstanceAgentCommandsResponse::builder).logger(LOG, "listInstanceAgentCommands").serviceDetails("ComputeInstanceAgent", "ListInstanceAgentCommands", "https://docs.oracle.com/iaas/api/#/en/instanceagent/20180530/InstanceAgentCommandSummary/ListInstanceAgentCommands").method(Method.GET).requestBuilder(ListInstanceAgentCommandsRequest::builder).basePath("/20180530").appendPathParam("instanceAgentCommands").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstanceAgentCommandSummary.class, ListInstanceAgentCommandsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceAgentCommandsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceAgentCommandsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ComputeInstanceAgentAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ComputeInstanceAgentAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ComputeInstanceAgentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ComputeInstanceAgentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ComputeInstanceAgentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ComputeInstanceAgentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeInstanceAgentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputeInstanceAgentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeInstanceAgentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ComputeInstanceAgentAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ComputeInstanceAgentAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

