/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.util.internal.NameUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Realm
implements Serializable,
Comparable<Realm> {
    private static final Map<String, Realm> KNOWN_REALMS = new LinkedHashMap<String, Realm>();
    public static final Realm OC1 = new Realm("oc1", "oraclecloud.com");
    public static final Realm OC2 = new Realm("oc2", "oraclegovcloud.com");
    public static final Realm OC3 = new Realm("oc3", "oraclegovcloud.com");
    public static final Realm OC4 = new Realm("oc4", "oraclegovcloud.uk");
    public static final Realm OC8 = new Realm("oc8", "oraclecloud8.com");
    public static final Realm OC9 = new Realm("oc9", "oraclecloud9.com");
    public static final Realm OC10 = new Realm("oc10", "oraclecloud10.com");
    public static final Realm OC14 = new Realm("oc14", "oraclecloud14.com");
    public static final Realm OC15 = new Realm("oc15", "oraclecloud15.com");
    public static final Realm OC16 = new Realm("oc16", "oraclecloud16.com");
    public static final Realm OC17 = new Realm("oc17", "oraclecloud17.com");
    public static final Realm OC18 = new Realm("oc18", "oraclecloud18.com");
    public static final Realm OC20 = new Realm("oc20", "oraclecloud20.com");
    private static final long serialVersionUID = -905344971L;
    private final String realmId;
    private final String secondLevelDomain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm(@Nonnull String realmId, @Nonnull String secondLevelDomain) {
        if (realmId == null) {
            throw new NullPointerException("realmId is marked non-null but is null");
        }
        if (secondLevelDomain == null) {
            throw new NullPointerException("secondLevelDomain is marked non-null but is null");
        }
        this.realmId = realmId;
        this.secondLevelDomain = secondLevelDomain;
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            KNOWN_REALMS.put(NameUtils.canonicalizeForEnumTypes(realmId), this);
        }
    }

    @Override
    public int compareTo(Realm other) {
        return this.realmId.compareTo(other.realmId);
    }

    public String toString() {
        return NameUtils.canonicalizeForEnumTypes(this.getRealmId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm[] values() {
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            return KNOWN_REALMS.values().toArray(new Realm[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm valueOf(@Nonnull String name) throws IllegalArgumentException {
        Realm realm;
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            realm = KNOWN_REALMS.get(name);
        }
        if (realm == null) {
            throw new IllegalArgumentException("Unknown realm " + name);
        }
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm register(@Nonnull String realmId, @Nonnull String secondLevelDomain) {
        if (realmId == null) {
            throw new NullPointerException("realmId is marked non-null but is null");
        }
        if (secondLevelDomain == null) {
            throw new NullPointerException("secondLevelDomain is marked non-null but is null");
        }
        realmId = realmId.toLowerCase(Locale.US);
        secondLevelDomain = secondLevelDomain.toLowerCase(Locale.US);
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            for (Realm realm : Realm.values()) {
                if (!realm.realmId.equals(realmId)) continue;
                if (!realm.secondLevelDomain.equals(secondLevelDomain)) {
                    throw new IllegalArgumentException("RealmId : " + realmId + " is already registered with " + realm.getSecondLevelDomain() + ". It cannot be re-registered with a different secondLevelDomain");
                }
                return realm;
            }
            return new Realm(realmId, secondLevelDomain);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Realm)) {
            return false;
        }
        Realm other = (Realm)o;
        String this$realmId = this.realmId;
        String other$realmId = other.realmId;
        if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
            return false;
        }
        String this$secondLevelDomain = this.secondLevelDomain;
        String other$secondLevelDomain = other.secondLevelDomain;
        return !(this$secondLevelDomain == null ? other$secondLevelDomain != null : !this$secondLevelDomain.equals(other$secondLevelDomain));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realmId = this.realmId;
        result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
        String $secondLevelDomain = this.secondLevelDomain;
        result = result * 59 + ($secondLevelDomain == null ? 43 : $secondLevelDomain.hashCode());
        return result;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getSecondLevelDomain() {
        return this.secondLevelDomain;
    }
}

