/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.io.internal.ResettableFileInputStream;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Retriers {
    private static final Logger LOG = LoggerFactory.getLogger(Retriers.class);
    private static volatile RetryConfiguration DEFAULT_RETRY_CONFIGURATION = RetryConfiguration.NO_RETRY_CONFIGURATION;
    private static volatile boolean SEND_OPC_RETRY_TOKEN = true;

    public static void setDefaultRetryConfiguration(@NonNull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked @NonNull but is null");
        }
        LOG.info("Setting default retry configuration to {}", (Object)retryConfiguration);
        DEFAULT_RETRY_CONFIGURATION = retryConfiguration;
    }

    public static void shouldSendOpcRetryToken(boolean shouldSendOpcRetryToken) {
        LOG.info("Setting shouldSendOpcRetryToken to {}", (Object)shouldSendOpcRetryToken);
        SEND_OPC_RETRY_TOKEN = shouldSendOpcRetryToken;
    }

    public static boolean shouldSendOpcRetryToken() {
        return SEND_OPC_RETRY_TOKEN;
    }

    public static BmcGenericRetrier createPreferredRetrier(@Nullable RetryConfiguration requestRetryConfiguration, @Nullable RetryConfiguration clientRetryConfiguration) {
        RetryConfiguration preferredRetryConfiguration = Stream.of(requestRetryConfiguration, clientRetryConfiguration, DEFAULT_RETRY_CONFIGURATION).filter(Objects::nonNull).findFirst().get();
        LOG.debug("Using retry configuration: {}", (Object)preferredRetryConfiguration);
        return new BmcGenericRetrier(preferredRetryConfiguration);
    }

    @InternalSdk
    public static void tryResetStreamForRetry(InputStream body) {
        if (body.markSupported()) {
            LOG.debug("mark/reset is supported, resetting stream {}", (Object)body.getClass().getName());
            try {
                body.reset();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to reset stream for next retry");
            }
        } else {
            LOG.warn("Stream {} does not support mark/reset, retries will not work", (Object)body.getClass().getName());
        }
    }

    @InternalSdk
    public static <T extends BmcRequest<InputStream>> T wrapBodyInputStreamIfNecessary(T request, BmcRequest.Builder<T, InputStream> builder) {
        KeepOpenInputStream wrappedStream;
        InputStream body = request.getBody$();
        if (body instanceof FileInputStream && ResettableFileInputStream.canBeWrapped((FileInputStream)body)) {
            LOG.debug("Wrapping FileInputStream in a ResettableFileInputStream");
            wrappedStream = new KeepOpenInputStream(new ResettableFileInputStream((FileInputStream)body));
        } else if (!body.markSupported()) {
            LOG.warn("stream does not support mark/reset or is a FileInputStream that doesn't allow changing the position, buffering in memory!");
            wrappedStream = new KeepOpenInputStream(new BufferedInputStream(body));
        } else {
            wrappedStream = new KeepOpenInputStream(body);
        }
        request = builder.copy(request).body$(wrappedStream).build();
        ((InputStream)wrappedStream).mark(Integer.MAX_VALUE);
        return request;
    }

    private Retriers() {
    }
}

