/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.CompositeClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.RestClientFactory;
import java.util.ArrayList;
import java.util.List;

public class RestClientFactoryBuilder {
    public static final ClientConfigurator DEFAULT_CONFIGURATOR = new DefaultConfigurator();
    private ClientConfigurator defaultConfigurator = DEFAULT_CONFIGURATOR;
    private ClientConfigurator clientConfigurator;
    private List<ClientConfigurator> additionalClientConfigurators = new ArrayList<ClientConfigurator>();

    public static RestClientFactoryBuilder builder() {
        return new RestClientFactoryBuilder();
    }

    public RestClientFactoryBuilder defaultConfigurator(ClientConfigurator defaultConfigurator) {
        this.defaultConfigurator = defaultConfigurator != null ? defaultConfigurator : DEFAULT_CONFIGURATOR;
        return this;
    }

    public RestClientFactoryBuilder clientConfigurator(ClientConfigurator clientConfigurator) {
        this.clientConfigurator = clientConfigurator;
        return this;
    }

    public RestClientFactoryBuilder additionalClientConfigurators(ClientConfigurator ... clientConfigurators) {
        this.additionalClientConfigurators = ImmutableList.copyOf((Object[])clientConfigurators);
        return this;
    }

    public RestClientFactoryBuilder additionalClientConfigurators(List<ClientConfigurator> clientConfigurators) {
        this.additionalClientConfigurators = ImmutableList.copyOf(clientConfigurators);
        return this;
    }

    public RestClientFactory build() {
        ClientConfigurator preferredClientConfigurator = this.getClientConfigurator();
        return new RestClientFactory(new CompositeClientConfigurator((List<ClientConfigurator>)ImmutableList.builder().add((Object)preferredClientConfigurator).addAll(this.additionalClientConfigurators).build()));
    }

    @InternalSdk
    @VisibleForTesting
    protected ClientConfigurator getClientConfigurator() {
        return (ClientConfigurator)MoreObjects.firstNonNull((Object)this.clientConfigurator, (Object)this.defaultConfigurator);
    }

    @InternalSdk
    @VisibleForTesting
    protected List<ClientConfigurator> getAdditionalClientConfigurators() {
        return this.additionalClientConfigurators;
    }

    protected RestClientFactoryBuilder() {
    }
}

