/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractRequestingAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.FileBasedKeySupplier;
import com.oracle.bmc.auth.internal.FileBasedResourcePrincipalFederationClient;
import com.oracle.bmc.auth.internal.FixedContentKeySupplier;
import com.oracle.bmc.auth.internal.FixedContentResourcePrincipalFederationClient;
import com.oracle.bmc.util.internal.NameUtils;
import java.io.File;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class ResourcePrincipalAuthenticationDetailsProvider
extends AbstractRequestingAuthenticationDetailsProvider
implements RegionProvider,
RefreshableOnNotAuthenticatedProvider<String> {
    static final String OCI_RESOURCE_PRINCIPAL_VERSION = "OCI_RESOURCE_PRINCIPAL_VERSION";
    static final String RP_VERSION_2_2 = "2.2";
    static final String OCI_RESOURCE_PRINCIPAL_RPST = "OCI_RESOURCE_PRINCIPAL_RPST";
    static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM";
    static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE";
    static final String OCI_RESOURCE_PRINCIPAL_REGION_ENV_VAR_NAME = "OCI_RESOURCE_PRINCIPAL_REGION";
    private final Region region;

    ResourcePrincipalAuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier, Region region) {
        super(federationClient, sessionKeySupplier);
        this.region = region;
    }

    public static ResourcePrincipalAuthenticationDetailsProviderBuilder builder() {
        return new ResourcePrincipalAuthenticationDetailsProviderBuilder();
    }

    public String getStringClaim(String key) {
        return this.federationClient.getStringClaim(key);
    }

    @Override
    public String refresh() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public static class ResourcePrincipalAuthenticationDetailsProviderBuilder {
        ResourcePrincipalAuthenticationDetailsProviderBuilder() {
        }

        public ResourcePrincipalAuthenticationDetailsProvider build() {
            String OciResourcePrincipalVersion = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_VERSION);
            if (OciResourcePrincipalVersion == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION environment variable missing");
            }
            switch (OciResourcePrincipalVersion) {
                case "2.2": {
                    String ociResourcePrincipalPrivateKey = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM);
                    String ociResourcePrincipalPassphrase = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE);
                    String ociResourcePrincipalRPST = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST);
                    String ociResourcePrincipalRegion = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_REGION_ENV_VAR_NAME);
                    String inputType = "environment variable";
                    return ResourcePrincipalAuthenticationDetailsProviderBuilder.build_2_2(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, ociResourcePrincipalRPST, ociResourcePrincipalRegion, "environment variable");
                }
            }
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION has unknown value");
        }

        public static ResourcePrincipalAuthenticationDetailsProvider build_2_2(String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String ociResourcePrincipalRPST, String ociResourcePrincipalRegion, String inputType) {
            SessionKeySupplier sessionKeySupplier;
            if (ociResourcePrincipalPrivateKey == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + inputType + " missing");
            }
            if (new File(ociResourcePrincipalPrivateKey).isAbsolute()) {
                if (ociResourcePrincipalPassphrase != null && !new File(ociResourcePrincipalPassphrase).isAbsolute()) {
                    throw new IllegalArgumentException("cannot mix path and constant settings for OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + ociResourcePrincipalPrivateKey + " and " + ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE + " " + ociResourcePrincipalPassphrase);
                }
                sessionKeySupplier = new FileBasedKeySupplier(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase);
            } else {
                char[] passPhraseChars = ociResourcePrincipalPassphrase != null ? ociResourcePrincipalPassphrase.toCharArray() : null;
                sessionKeySupplier = new FixedContentKeySupplier(ociResourcePrincipalPrivateKey, passPhraseChars);
            }
            if (ociResourcePrincipalRPST == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_RPST " + inputType + " missing");
            }
            FederationClient federationClient = new File(ociResourcePrincipalRPST).isAbsolute() ? new FileBasedResourcePrincipalFederationClient(sessionKeySupplier, ociResourcePrincipalRPST) : new FixedContentResourcePrincipalFederationClient(ociResourcePrincipalRPST, sessionKeySupplier);
            if (ociResourcePrincipalRegion == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_REGION " + inputType + " missing");
            }
            Region region = Region.valueOf(NameUtils.canonicalizeForEnumTypes(ociResourcePrincipalRegion));
            return new ResourcePrincipalAuthenticationDetailsProvider(federationClient, sessionKeySupplier, region);
        }
    }

    public static class ClaimKeys {
        public static final String COMPARTMENT_ID_CLAIM_KEY = "res_compartment";
        public static final String TENANT_ID_CLAIM_KEY = "res_tenant";
    }
}

