/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3;

import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.jersey3.Jersey3HttpRequest;
import com.oracle.bmc.http.client.jersey3.internal.IdleConnectionMonitor;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import java.util.List;
import java.util.function.Supplier;
import org.apache.http.conn.HttpClientConnectionManager;

final class Jersey3HttpClient
implements HttpClient {
    final List<RequestInterceptor> requestInterceptors;
    private volatile Supplier<WebTarget> baseTargetSupplier;
    final Client client;
    final boolean isApacheNonBufferingClient;
    final HttpClientConnectionManager httpClientConnectionManager;

    Jersey3HttpClient(Client client, WebTarget baseTarget, List<RequestInterceptor> requestInterceptors, boolean isApacheNonBufferingClient) {
        this(client, baseTarget, requestInterceptors, isApacheNonBufferingClient, null);
    }

    Jersey3HttpClient(Client client, WebTarget baseTarget, List<RequestInterceptor> requestInterceptors, boolean isApacheNonBufferingClient, HttpClientConnectionManager httpClientConnectionManager) {
        if (client == null) {
            throw new IllegalArgumentException("Client must be non-null");
        }
        if (baseTarget == null) {
            throw new IllegalArgumentException("Endpoint must be non-null");
        }
        this.client = client;
        this.baseTargetSupplier = () -> baseTarget;
        this.requestInterceptors = requestInterceptors;
        this.isApacheNonBufferingClient = isApacheNonBufferingClient;
        this.httpClientConnectionManager = httpClientConnectionManager;
    }

    public HttpRequest createRequest(Method method) {
        return new Jersey3HttpRequest(this, method, this.baseTargetSupplier.get());
    }

    public void close() {
        if (this.httpClientConnectionManager != null) {
            IdleConnectionMonitor.removeConnectionManager(this.httpClientConnectionManager);
        }
        this.client.close();
    }

    public boolean isProcessingException(Exception e) {
        return e instanceof ProcessingException;
    }

    public synchronized void updateEndpoint(String baseTarget) {
        if (!(this.baseTargetSupplier instanceof ThreadLocalWebTargetSupplier)) {
            this.baseTargetSupplier = new ThreadLocalWebTargetSupplier(this.baseTargetSupplier);
        }
        ThreadLocalWebTargetSupplier supplier = (ThreadLocalWebTargetSupplier)this.baseTargetSupplier;
        supplier.set(this.client.target(baseTarget));
    }

    static final class ThreadLocalWebTargetSupplier
    implements Supplier<WebTarget> {
        private final ThreadLocal<WebTarget> threadLocal;

        public ThreadLocalWebTargetSupplier(Supplier<WebTarget> initial) {
            this.threadLocal = ThreadLocal.withInitial(initial);
        }

        @Override
        public WebTarget get() {
            return this.threadLocal.get();
        }

        public void set(WebTarget updated) {
            this.threadLocal.set(updated);
        }
    }
}

