/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudmigrations.model.UpdateTargetAssetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTargetAssetRequest
extends BmcRequest<UpdateTargetAssetDetails> {
    private String targetAssetId;
    private UpdateTargetAssetDetails updateTargetAssetDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getTargetAssetId() {
        return this.targetAssetId;
    }

    public UpdateTargetAssetDetails getUpdateTargetAssetDetails() {
        return this.updateTargetAssetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateTargetAssetDetails getBody$() {
        return this.updateTargetAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().targetAssetId(this.targetAssetId).updateTargetAssetDetails(this.updateTargetAssetDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetAssetId=").append(String.valueOf(this.targetAssetId));
        sb.append(",updateTargetAssetDetails=").append(String.valueOf((Object)this.updateTargetAssetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTargetAssetRequest)) {
            return false;
        }
        UpdateTargetAssetRequest other = (UpdateTargetAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetAssetId, other.targetAssetId) && Objects.equals((Object)this.updateTargetAssetDetails, (Object)other.updateTargetAssetDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetAssetId == null ? 43 : this.targetAssetId.hashCode());
        result = result * 59 + (this.updateTargetAssetDetails == null ? 43 : this.updateTargetAssetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTargetAssetRequest, UpdateTargetAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetAssetId = null;
        private UpdateTargetAssetDetails updateTargetAssetDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder targetAssetId(String targetAssetId) {
            this.targetAssetId = targetAssetId;
            return this;
        }

        public Builder updateTargetAssetDetails(UpdateTargetAssetDetails updateTargetAssetDetails) {
            this.updateTargetAssetDetails = updateTargetAssetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTargetAssetRequest o) {
            this.targetAssetId(o.getTargetAssetId());
            this.updateTargetAssetDetails(o.getUpdateTargetAssetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTargetAssetRequest build() {
            UpdateTargetAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTargetAssetDetails body) {
            this.updateTargetAssetDetails(body);
            return this;
        }

        public UpdateTargetAssetRequest buildWithoutInvocationCallback() {
            UpdateTargetAssetRequest request = new UpdateTargetAssetRequest();
            request.targetAssetId = this.targetAssetId;
            request.updateTargetAssetDetails = this.updateTargetAssetDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

