/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.AssetSource;
import com.oracle.bmc.cloudmigrations.model.AssetSourceCredentials;
import com.oracle.bmc.cloudmigrations.model.AssetSourceLifecycleState;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class VmWareAssetSource
extends AssetSource {
    @JsonProperty(value="vcenterEndpoint")
    private final String vcenterEndpoint;
    @JsonProperty(value="discoveryCredentials")
    private final AssetSourceCredentials discoveryCredentials;
    @JsonProperty(value="replicationCredentials")
    private final AssetSourceCredentials replicationCredentials;
    @JsonProperty(value="areHistoricalMetricsCollected")
    private final Boolean areHistoricalMetricsCollected;
    @JsonProperty(value="areRealtimeMetricsCollected")
    private final Boolean areRealtimeMetricsCollected;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VmWareAssetSource(String id, String compartmentId, String displayName, String environmentId, String inventoryId, String assetsCompartmentId, String discoveryScheduleId, AssetSourceLifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String vcenterEndpoint, AssetSourceCredentials discoveryCredentials, AssetSourceCredentials replicationCredentials, Boolean areHistoricalMetricsCollected, Boolean areRealtimeMetricsCollected) {
        super(id, compartmentId, displayName, environmentId, inventoryId, assetsCompartmentId, discoveryScheduleId, lifecycleState, lifecycleDetails, timeCreated, timeUpdated, freeformTags, definedTags, systemTags);
        this.vcenterEndpoint = vcenterEndpoint;
        this.discoveryCredentials = discoveryCredentials;
        this.replicationCredentials = replicationCredentials;
        this.areHistoricalMetricsCollected = areHistoricalMetricsCollected;
        this.areRealtimeMetricsCollected = areRealtimeMetricsCollected;
    }

    public String getVcenterEndpoint() {
        return this.vcenterEndpoint;
    }

    public AssetSourceCredentials getDiscoveryCredentials() {
        return this.discoveryCredentials;
    }

    public AssetSourceCredentials getReplicationCredentials() {
        return this.replicationCredentials;
    }

    public Boolean getAreHistoricalMetricsCollected() {
        return this.areHistoricalMetricsCollected;
    }

    public Boolean getAreRealtimeMetricsCollected() {
        return this.areRealtimeMetricsCollected;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmWareAssetSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vcenterEndpoint=").append(String.valueOf(this.vcenterEndpoint));
        sb.append(", discoveryCredentials=").append(String.valueOf((Object)this.discoveryCredentials));
        sb.append(", replicationCredentials=").append(String.valueOf((Object)this.replicationCredentials));
        sb.append(", areHistoricalMetricsCollected=").append(String.valueOf(this.areHistoricalMetricsCollected));
        sb.append(", areRealtimeMetricsCollected=").append(String.valueOf(this.areRealtimeMetricsCollected));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmWareAssetSource)) {
            return false;
        }
        VmWareAssetSource other = (VmWareAssetSource)((Object)o);
        return Objects.equals(this.vcenterEndpoint, other.vcenterEndpoint) && Objects.equals((Object)this.discoveryCredentials, (Object)other.discoveryCredentials) && Objects.equals((Object)this.replicationCredentials, (Object)other.replicationCredentials) && Objects.equals(this.areHistoricalMetricsCollected, other.areHistoricalMetricsCollected) && Objects.equals(this.areRealtimeMetricsCollected, other.areRealtimeMetricsCollected) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vcenterEndpoint == null ? 43 : this.vcenterEndpoint.hashCode());
        result = result * 59 + (this.discoveryCredentials == null ? 43 : this.discoveryCredentials.hashCode());
        result = result * 59 + (this.replicationCredentials == null ? 43 : this.replicationCredentials.hashCode());
        result = result * 59 + (this.areHistoricalMetricsCollected == null ? 43 : this.areHistoricalMetricsCollected.hashCode());
        result = result * 59 + (this.areRealtimeMetricsCollected == null ? 43 : this.areRealtimeMetricsCollected.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="environmentId")
        private String environmentId;
        @JsonProperty(value="inventoryId")
        private String inventoryId;
        @JsonProperty(value="assetsCompartmentId")
        private String assetsCompartmentId;
        @JsonProperty(value="discoveryScheduleId")
        private String discoveryScheduleId;
        @JsonProperty(value="lifecycleState")
        private AssetSourceLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="vcenterEndpoint")
        private String vcenterEndpoint;
        @JsonProperty(value="discoveryCredentials")
        private AssetSourceCredentials discoveryCredentials;
        @JsonProperty(value="replicationCredentials")
        private AssetSourceCredentials replicationCredentials;
        @JsonProperty(value="areHistoricalMetricsCollected")
        private Boolean areHistoricalMetricsCollected;
        @JsonProperty(value="areRealtimeMetricsCollected")
        private Boolean areRealtimeMetricsCollected;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            this.__explicitlySet__.add("environmentId");
            return this;
        }

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            this.__explicitlySet__.add("inventoryId");
            return this;
        }

        public Builder assetsCompartmentId(String assetsCompartmentId) {
            this.assetsCompartmentId = assetsCompartmentId;
            this.__explicitlySet__.add("assetsCompartmentId");
            return this;
        }

        public Builder discoveryScheduleId(String discoveryScheduleId) {
            this.discoveryScheduleId = discoveryScheduleId;
            this.__explicitlySet__.add("discoveryScheduleId");
            return this;
        }

        public Builder lifecycleState(AssetSourceLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder vcenterEndpoint(String vcenterEndpoint) {
            this.vcenterEndpoint = vcenterEndpoint;
            this.__explicitlySet__.add("vcenterEndpoint");
            return this;
        }

        public Builder discoveryCredentials(AssetSourceCredentials discoveryCredentials) {
            this.discoveryCredentials = discoveryCredentials;
            this.__explicitlySet__.add("discoveryCredentials");
            return this;
        }

        public Builder replicationCredentials(AssetSourceCredentials replicationCredentials) {
            this.replicationCredentials = replicationCredentials;
            this.__explicitlySet__.add("replicationCredentials");
            return this;
        }

        public Builder areHistoricalMetricsCollected(Boolean areHistoricalMetricsCollected) {
            this.areHistoricalMetricsCollected = areHistoricalMetricsCollected;
            this.__explicitlySet__.add("areHistoricalMetricsCollected");
            return this;
        }

        public Builder areRealtimeMetricsCollected(Boolean areRealtimeMetricsCollected) {
            this.areRealtimeMetricsCollected = areRealtimeMetricsCollected;
            this.__explicitlySet__.add("areRealtimeMetricsCollected");
            return this;
        }

        public VmWareAssetSource build() {
            VmWareAssetSource model = new VmWareAssetSource(this.id, this.compartmentId, this.displayName, this.environmentId, this.inventoryId, this.assetsCompartmentId, this.discoveryScheduleId, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.systemTags, this.vcenterEndpoint, this.discoveryCredentials, this.replicationCredentials, this.areHistoricalMetricsCollected, this.areRealtimeMetricsCollected);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmWareAssetSource model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("environmentId")) {
                this.environmentId(model.getEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("inventoryId")) {
                this.inventoryId(model.getInventoryId());
            }
            if (model.wasPropertyExplicitlySet("assetsCompartmentId")) {
                this.assetsCompartmentId(model.getAssetsCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("discoveryScheduleId")) {
                this.discoveryScheduleId(model.getDiscoveryScheduleId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("vcenterEndpoint")) {
                this.vcenterEndpoint(model.getVcenterEndpoint());
            }
            if (model.wasPropertyExplicitlySet("discoveryCredentials")) {
                this.discoveryCredentials(model.getDiscoveryCredentials());
            }
            if (model.wasPropertyExplicitlySet("replicationCredentials")) {
                this.replicationCredentials(model.getReplicationCredentials());
            }
            if (model.wasPropertyExplicitlySet("areHistoricalMetricsCollected")) {
                this.areHistoricalMetricsCollected(model.getAreHistoricalMetricsCollected());
            }
            if (model.wasPropertyExplicitlySet("areRealtimeMetricsCollected")) {
                this.areRealtimeMetricsCollected(model.getAreRealtimeMetricsCollected());
            }
            return this;
        }
    }
}

