/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.TargetEnvironment;
import com.oracle.bmc.cloudmigrations.model.VmTargetAsset;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="targetEnvironmentType")
@JsonFilter(value="explicitlySetFilter")
public final class VmTargetEnvironment
extends TargetEnvironment {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="vcn")
    private final String vcn;
    @JsonProperty(value="subnet")
    private final String subnet;
    @JsonProperty(value="dedicatedVmHost")
    private final String dedicatedVmHost;
    @JsonProperty(value="msLicense")
    private final String msLicense;
    @JsonProperty(value="preferredShapeType")
    private final VmTargetAsset.PreferredShapeType preferredShapeType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VmTargetEnvironment(String targetCompartmentId, String availabilityDomain, String faultDomain, String vcn, String subnet, String dedicatedVmHost, String msLicense, VmTargetAsset.PreferredShapeType preferredShapeType) {
        super(targetCompartmentId);
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.vcn = vcn;
        this.subnet = subnet;
        this.dedicatedVmHost = dedicatedVmHost;
        this.msLicense = msLicense;
        this.preferredShapeType = preferredShapeType;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getVcn() {
        return this.vcn;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public String getDedicatedVmHost() {
        return this.dedicatedVmHost;
    }

    public String getMsLicense() {
        return this.msLicense;
    }

    public VmTargetAsset.PreferredShapeType getPreferredShapeType() {
        return this.preferredShapeType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmTargetEnvironment(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", vcn=").append(String.valueOf(this.vcn));
        sb.append(", subnet=").append(String.valueOf(this.subnet));
        sb.append(", dedicatedVmHost=").append(String.valueOf(this.dedicatedVmHost));
        sb.append(", msLicense=").append(String.valueOf(this.msLicense));
        sb.append(", preferredShapeType=").append(String.valueOf((Object)this.preferredShapeType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmTargetEnvironment)) {
            return false;
        }
        VmTargetEnvironment other = (VmTargetEnvironment)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.vcn, other.vcn) && Objects.equals(this.subnet, other.subnet) && Objects.equals(this.dedicatedVmHost, other.dedicatedVmHost) && Objects.equals(this.msLicense, other.msLicense) && Objects.equals((Object)this.preferredShapeType, (Object)other.preferredShapeType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.vcn == null ? 43 : this.vcn.hashCode());
        result = result * 59 + (this.subnet == null ? 43 : this.subnet.hashCode());
        result = result * 59 + (this.dedicatedVmHost == null ? 43 : this.dedicatedVmHost.hashCode());
        result = result * 59 + (this.msLicense == null ? 43 : this.msLicense.hashCode());
        result = result * 59 + (this.preferredShapeType == null ? 43 : this.preferredShapeType.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetCompartmentId")
        private String targetCompartmentId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="vcn")
        private String vcn;
        @JsonProperty(value="subnet")
        private String subnet;
        @JsonProperty(value="dedicatedVmHost")
        private String dedicatedVmHost;
        @JsonProperty(value="msLicense")
        private String msLicense;
        @JsonProperty(value="preferredShapeType")
        private VmTargetAsset.PreferredShapeType preferredShapeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetCompartmentId(String targetCompartmentId) {
            this.targetCompartmentId = targetCompartmentId;
            this.__explicitlySet__.add("targetCompartmentId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder vcn(String vcn) {
            this.vcn = vcn;
            this.__explicitlySet__.add("vcn");
            return this;
        }

        public Builder subnet(String subnet) {
            this.subnet = subnet;
            this.__explicitlySet__.add("subnet");
            return this;
        }

        public Builder dedicatedVmHost(String dedicatedVmHost) {
            this.dedicatedVmHost = dedicatedVmHost;
            this.__explicitlySet__.add("dedicatedVmHost");
            return this;
        }

        public Builder msLicense(String msLicense) {
            this.msLicense = msLicense;
            this.__explicitlySet__.add("msLicense");
            return this;
        }

        public Builder preferredShapeType(VmTargetAsset.PreferredShapeType preferredShapeType) {
            this.preferredShapeType = preferredShapeType;
            this.__explicitlySet__.add("preferredShapeType");
            return this;
        }

        public VmTargetEnvironment build() {
            VmTargetEnvironment model = new VmTargetEnvironment(this.targetCompartmentId, this.availabilityDomain, this.faultDomain, this.vcn, this.subnet, this.dedicatedVmHost, this.msLicense, this.preferredShapeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmTargetEnvironment model) {
            if (model.wasPropertyExplicitlySet("targetCompartmentId")) {
                this.targetCompartmentId(model.getTargetCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("vcn")) {
                this.vcn(model.getVcn());
            }
            if (model.wasPropertyExplicitlySet("subnet")) {
                this.subnet(model.getSubnet());
            }
            if (model.wasPropertyExplicitlySet("dedicatedVmHost")) {
                this.dedicatedVmHost(model.getDedicatedVmHost());
            }
            if (model.wasPropertyExplicitlySet("msLicense")) {
                this.msLicense(model.getMsLicense());
            }
            if (model.wasPropertyExplicitlySet("preferredShapeType")) {
                this.preferredShapeType(model.getPreferredShapeType());
            }
            return this;
        }
    }
}

