/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudmigrations.model.AsIsResourceAssessmentStrategy;
import com.oracle.bmc.cloudmigrations.model.AverageResourceAssessmentStrategy;
import com.oracle.bmc.cloudmigrations.model.PeakResourceAssessmentStrategy;
import com.oracle.bmc.cloudmigrations.model.PercentileResourceAssessmentStrategy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="strategyType", defaultImpl=ResourceAssessmentStrategy.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PeakResourceAssessmentStrategy.class, name="PEAK"), @JsonSubTypes.Type(value=PercentileResourceAssessmentStrategy.class, name="PERCENTILE"), @JsonSubTypes.Type(value=AverageResourceAssessmentStrategy.class, name="AVERAGE"), @JsonSubTypes.Type(value=AsIsResourceAssessmentStrategy.class, name="AS_IS")})
@JsonFilter(value="explicitlySetFilter")
public class ResourceAssessmentStrategy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;

    @Deprecated
    @ConstructorProperties(value={"resourceType"})
    protected ResourceAssessmentStrategy(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceAssessmentStrategy(");
        sb.append("super=").append(super.toString());
        sb.append("resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceAssessmentStrategy)) {
            return false;
        }
        ResourceAssessmentStrategy other = (ResourceAssessmentStrategy)((Object)o);
        return Objects.equals((Object)this.resourceType, (Object)other.resourceType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StrategyType implements BmcEnum
    {
        AsIs("AS_IS"),
        Average("AVERAGE"),
        Peak("PEAK"),
        Percentile("PERCENTILE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StrategyType> map;

        private StrategyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StrategyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StrategyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StrategyType.class);
            map = new HashMap<String, StrategyType>();
            for (StrategyType v : StrategyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceType implements BmcEnum
    {
        Cpu("CPU"),
        Memory("MEMORY"),
        All("ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

