/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReplicationProgress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="percentage")
    private final Integer percentage;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeOflastReplicationStart")
    private final Date timeOflastReplicationStart;
    @JsonProperty(value="timeOfLastReplicationEnd")
    private final Date timeOfLastReplicationEnd;
    @JsonProperty(value="timeOfLastReplicationSuccess")
    private final Date timeOfLastReplicationSuccess;
    @JsonProperty(value="lastReplicationStatus")
    private final LastReplicationStatus lastReplicationStatus;
    @JsonProperty(value="lastReplicationError")
    private final String lastReplicationError;

    @Deprecated
    @ConstructorProperties(value={"percentage", "status", "timeStarted", "timeOflastReplicationStart", "timeOfLastReplicationEnd", "timeOfLastReplicationSuccess", "lastReplicationStatus", "lastReplicationError"})
    public ReplicationProgress(Integer percentage, Status status, Date timeStarted, Date timeOflastReplicationStart, Date timeOfLastReplicationEnd, Date timeOfLastReplicationSuccess, LastReplicationStatus lastReplicationStatus, String lastReplicationError) {
        this.percentage = percentage;
        this.status = status;
        this.timeStarted = timeStarted;
        this.timeOflastReplicationStart = timeOflastReplicationStart;
        this.timeOfLastReplicationEnd = timeOfLastReplicationEnd;
        this.timeOfLastReplicationSuccess = timeOfLastReplicationSuccess;
        this.lastReplicationStatus = lastReplicationStatus;
        this.lastReplicationError = lastReplicationError;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeOflastReplicationStart() {
        return this.timeOflastReplicationStart;
    }

    public Date getTimeOfLastReplicationEnd() {
        return this.timeOfLastReplicationEnd;
    }

    public Date getTimeOfLastReplicationSuccess() {
        return this.timeOfLastReplicationSuccess;
    }

    public LastReplicationStatus getLastReplicationStatus() {
        return this.lastReplicationStatus;
    }

    public String getLastReplicationError() {
        return this.lastReplicationError;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicationProgress(");
        sb.append("super=").append(super.toString());
        sb.append("percentage=").append(String.valueOf(this.percentage));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeOflastReplicationStart=").append(String.valueOf(this.timeOflastReplicationStart));
        sb.append(", timeOfLastReplicationEnd=").append(String.valueOf(this.timeOfLastReplicationEnd));
        sb.append(", timeOfLastReplicationSuccess=").append(String.valueOf(this.timeOfLastReplicationSuccess));
        sb.append(", lastReplicationStatus=").append(String.valueOf((Object)this.lastReplicationStatus));
        sb.append(", lastReplicationError=").append(String.valueOf(this.lastReplicationError));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationProgress)) {
            return false;
        }
        ReplicationProgress other = (ReplicationProgress)((Object)o);
        return Objects.equals(this.percentage, other.percentage) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeOflastReplicationStart, other.timeOflastReplicationStart) && Objects.equals(this.timeOfLastReplicationEnd, other.timeOfLastReplicationEnd) && Objects.equals(this.timeOfLastReplicationSuccess, other.timeOfLastReplicationSuccess) && Objects.equals((Object)this.lastReplicationStatus, (Object)other.lastReplicationStatus) && Objects.equals(this.lastReplicationError, other.lastReplicationError) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.percentage == null ? 43 : this.percentage.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeOflastReplicationStart == null ? 43 : this.timeOflastReplicationStart.hashCode());
        result = result * 59 + (this.timeOfLastReplicationEnd == null ? 43 : this.timeOfLastReplicationEnd.hashCode());
        result = result * 59 + (this.timeOfLastReplicationSuccess == null ? 43 : this.timeOfLastReplicationSuccess.hashCode());
        result = result * 59 + (this.lastReplicationStatus == null ? 43 : this.lastReplicationStatus.hashCode());
        result = result * 59 + (this.lastReplicationError == null ? 43 : this.lastReplicationError.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LastReplicationStatus implements BmcEnum
    {
        None("NONE"),
        Completed("COMPLETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LastReplicationStatus> map;

        private LastReplicationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LastReplicationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LastReplicationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LastReplicationStatus.class);
            map = new HashMap<String, LastReplicationStatus>();
            for (LastReplicationStatus v : LastReplicationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        None("NONE"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="percentage")
        private Integer percentage;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeOflastReplicationStart")
        private Date timeOflastReplicationStart;
        @JsonProperty(value="timeOfLastReplicationEnd")
        private Date timeOfLastReplicationEnd;
        @JsonProperty(value="timeOfLastReplicationSuccess")
        private Date timeOfLastReplicationSuccess;
        @JsonProperty(value="lastReplicationStatus")
        private LastReplicationStatus lastReplicationStatus;
        @JsonProperty(value="lastReplicationError")
        private String lastReplicationError;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder percentage(Integer percentage) {
            this.percentage = percentage;
            this.__explicitlySet__.add("percentage");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeOflastReplicationStart(Date timeOflastReplicationStart) {
            this.timeOflastReplicationStart = timeOflastReplicationStart;
            this.__explicitlySet__.add("timeOflastReplicationStart");
            return this;
        }

        public Builder timeOfLastReplicationEnd(Date timeOfLastReplicationEnd) {
            this.timeOfLastReplicationEnd = timeOfLastReplicationEnd;
            this.__explicitlySet__.add("timeOfLastReplicationEnd");
            return this;
        }

        public Builder timeOfLastReplicationSuccess(Date timeOfLastReplicationSuccess) {
            this.timeOfLastReplicationSuccess = timeOfLastReplicationSuccess;
            this.__explicitlySet__.add("timeOfLastReplicationSuccess");
            return this;
        }

        public Builder lastReplicationStatus(LastReplicationStatus lastReplicationStatus) {
            this.lastReplicationStatus = lastReplicationStatus;
            this.__explicitlySet__.add("lastReplicationStatus");
            return this;
        }

        public Builder lastReplicationError(String lastReplicationError) {
            this.lastReplicationError = lastReplicationError;
            this.__explicitlySet__.add("lastReplicationError");
            return this;
        }

        public ReplicationProgress build() {
            ReplicationProgress model = new ReplicationProgress(this.percentage, this.status, this.timeStarted, this.timeOflastReplicationStart, this.timeOfLastReplicationEnd, this.timeOfLastReplicationSuccess, this.lastReplicationStatus, this.lastReplicationError);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReplicationProgress model) {
            if (model.wasPropertyExplicitlySet("percentage")) {
                this.percentage(model.getPercentage());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeOflastReplicationStart")) {
                this.timeOflastReplicationStart(model.getTimeOflastReplicationStart());
            }
            if (model.wasPropertyExplicitlySet("timeOfLastReplicationEnd")) {
                this.timeOfLastReplicationEnd(model.getTimeOfLastReplicationEnd());
            }
            if (model.wasPropertyExplicitlySet("timeOfLastReplicationSuccess")) {
                this.timeOfLastReplicationSuccess(model.getTimeOfLastReplicationSuccess());
            }
            if (model.wasPropertyExplicitlySet("lastReplicationStatus")) {
                this.lastReplicationStatus(model.getLastReplicationStatus());
            }
            if (model.wasPropertyExplicitlySet("lastReplicationError")) {
                this.lastReplicationError(model.getLastReplicationError());
            }
            return this;
        }
    }
}

