/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HydratedVolume
extends ExplicitlySetBmcModel {
    @JsonProperty(value="uuid")
    private final String uuid;
    @JsonProperty(value="volumeId")
    private final String volumeId;
    @JsonProperty(value="volumeType")
    private final VolumeType volumeType;
    @JsonProperty(value="unmodifiedVolumeId")
    private final String unmodifiedVolumeId;

    @Deprecated
    @ConstructorProperties(value={"uuid", "volumeId", "volumeType", "unmodifiedVolumeId"})
    public HydratedVolume(String uuid, String volumeId, VolumeType volumeType, String unmodifiedVolumeId) {
        this.uuid = uuid;
        this.volumeId = volumeId;
        this.volumeType = volumeType;
        this.unmodifiedVolumeId = unmodifiedVolumeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public VolumeType getVolumeType() {
        return this.volumeType;
    }

    public String getUnmodifiedVolumeId() {
        return this.unmodifiedVolumeId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HydratedVolume(");
        sb.append("super=").append(super.toString());
        sb.append("uuid=").append(String.valueOf(this.uuid));
        sb.append(", volumeId=").append(String.valueOf(this.volumeId));
        sb.append(", volumeType=").append(String.valueOf((Object)this.volumeType));
        sb.append(", unmodifiedVolumeId=").append(String.valueOf(this.unmodifiedVolumeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HydratedVolume)) {
            return false;
        }
        HydratedVolume other = (HydratedVolume)((Object)o);
        return Objects.equals(this.uuid, other.uuid) && Objects.equals(this.volumeId, other.volumeId) && Objects.equals((Object)this.volumeType, (Object)other.volumeType) && Objects.equals(this.unmodifiedVolumeId, other.unmodifiedVolumeId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.uuid == null ? 43 : this.uuid.hashCode());
        result = result * 59 + (this.volumeId == null ? 43 : this.volumeId.hashCode());
        result = result * 59 + (this.volumeType == null ? 43 : this.volumeType.hashCode());
        result = result * 59 + (this.unmodifiedVolumeId == null ? 43 : this.unmodifiedVolumeId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum VolumeType implements BmcEnum
    {
        Boot("BOOT"),
        Block("BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, VolumeType> map;

        private VolumeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VolumeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'VolumeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(VolumeType.class);
            map = new HashMap<String, VolumeType>();
            for (VolumeType v : VolumeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="volumeId")
        private String volumeId;
        @JsonProperty(value="volumeType")
        private VolumeType volumeType;
        @JsonProperty(value="unmodifiedVolumeId")
        private String unmodifiedVolumeId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            this.__explicitlySet__.add("uuid");
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            this.__explicitlySet__.add("volumeId");
            return this;
        }

        public Builder volumeType(VolumeType volumeType) {
            this.volumeType = volumeType;
            this.__explicitlySet__.add("volumeType");
            return this;
        }

        public Builder unmodifiedVolumeId(String unmodifiedVolumeId) {
            this.unmodifiedVolumeId = unmodifiedVolumeId;
            this.__explicitlySet__.add("unmodifiedVolumeId");
            return this;
        }

        public HydratedVolume build() {
            HydratedVolume model = new HydratedVolume(this.uuid, this.volumeId, this.volumeType, this.unmodifiedVolumeId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HydratedVolume model) {
            if (model.wasPropertyExplicitlySet("uuid")) {
                this.uuid(model.getUuid());
            }
            if (model.wasPropertyExplicitlySet("volumeId")) {
                this.volumeId(model.getVolumeId());
            }
            if (model.wasPropertyExplicitlySet("volumeType")) {
                this.volumeType(model.getVolumeType());
            }
            if (model.wasPropertyExplicitlySet("unmodifiedVolumeId")) {
                this.unmodifiedVolumeId(model.getUnmodifiedVolumeId());
            }
            return this;
        }
    }
}

