/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.ComputeCostEstimation;
import com.oracle.bmc.cloudmigrations.model.OsImageEstimation;
import com.oracle.bmc.cloudmigrations.model.StorageCostEstimation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CostEstimation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compute")
    private final ComputeCostEstimation compute;
    @JsonProperty(value="storage")
    private final StorageCostEstimation storage;
    @JsonProperty(value="osImage")
    private final OsImageEstimation osImage;
    @JsonProperty(value="currencyCode")
    private final String currencyCode;
    @JsonProperty(value="totalEstimationPerMonth")
    private final BigDecimal totalEstimationPerMonth;
    @JsonProperty(value="totalEstimationPerMonthBySubscription")
    private final BigDecimal totalEstimationPerMonthBySubscription;
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;

    @Deprecated
    @ConstructorProperties(value={"compute", "storage", "osImage", "currencyCode", "totalEstimationPerMonth", "totalEstimationPerMonthBySubscription", "subscriptionId"})
    public CostEstimation(ComputeCostEstimation compute, StorageCostEstimation storage, OsImageEstimation osImage, String currencyCode, BigDecimal totalEstimationPerMonth, BigDecimal totalEstimationPerMonthBySubscription, String subscriptionId) {
        this.compute = compute;
        this.storage = storage;
        this.osImage = osImage;
        this.currencyCode = currencyCode;
        this.totalEstimationPerMonth = totalEstimationPerMonth;
        this.totalEstimationPerMonthBySubscription = totalEstimationPerMonthBySubscription;
        this.subscriptionId = subscriptionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ComputeCostEstimation getCompute() {
        return this.compute;
    }

    public StorageCostEstimation getStorage() {
        return this.storage;
    }

    public OsImageEstimation getOsImage() {
        return this.osImage;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public BigDecimal getTotalEstimationPerMonth() {
        return this.totalEstimationPerMonth;
    }

    public BigDecimal getTotalEstimationPerMonthBySubscription() {
        return this.totalEstimationPerMonthBySubscription;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CostEstimation(");
        sb.append("super=").append(super.toString());
        sb.append("compute=").append(String.valueOf((Object)this.compute));
        sb.append(", storage=").append(String.valueOf((Object)this.storage));
        sb.append(", osImage=").append(String.valueOf((Object)this.osImage));
        sb.append(", currencyCode=").append(String.valueOf(this.currencyCode));
        sb.append(", totalEstimationPerMonth=").append(String.valueOf(this.totalEstimationPerMonth));
        sb.append(", totalEstimationPerMonthBySubscription=").append(String.valueOf(this.totalEstimationPerMonthBySubscription));
        sb.append(", subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CostEstimation)) {
            return false;
        }
        CostEstimation other = (CostEstimation)((Object)o);
        return Objects.equals((Object)this.compute, (Object)other.compute) && Objects.equals((Object)this.storage, (Object)other.storage) && Objects.equals((Object)this.osImage, (Object)other.osImage) && Objects.equals(this.currencyCode, other.currencyCode) && Objects.equals(this.totalEstimationPerMonth, other.totalEstimationPerMonth) && Objects.equals(this.totalEstimationPerMonthBySubscription, other.totalEstimationPerMonthBySubscription) && Objects.equals(this.subscriptionId, other.subscriptionId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compute == null ? 43 : this.compute.hashCode());
        result = result * 59 + (this.storage == null ? 43 : this.storage.hashCode());
        result = result * 59 + (this.osImage == null ? 43 : this.osImage.hashCode());
        result = result * 59 + (this.currencyCode == null ? 43 : this.currencyCode.hashCode());
        result = result * 59 + (this.totalEstimationPerMonth == null ? 43 : this.totalEstimationPerMonth.hashCode());
        result = result * 59 + (this.totalEstimationPerMonthBySubscription == null ? 43 : this.totalEstimationPerMonthBySubscription.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compute")
        private ComputeCostEstimation compute;
        @JsonProperty(value="storage")
        private StorageCostEstimation storage;
        @JsonProperty(value="osImage")
        private OsImageEstimation osImage;
        @JsonProperty(value="currencyCode")
        private String currencyCode;
        @JsonProperty(value="totalEstimationPerMonth")
        private BigDecimal totalEstimationPerMonth;
        @JsonProperty(value="totalEstimationPerMonthBySubscription")
        private BigDecimal totalEstimationPerMonthBySubscription;
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compute(ComputeCostEstimation compute) {
            this.compute = compute;
            this.__explicitlySet__.add("compute");
            return this;
        }

        public Builder storage(StorageCostEstimation storage) {
            this.storage = storage;
            this.__explicitlySet__.add("storage");
            return this;
        }

        public Builder osImage(OsImageEstimation osImage) {
            this.osImage = osImage;
            this.__explicitlySet__.add("osImage");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.__explicitlySet__.add("currencyCode");
            return this;
        }

        public Builder totalEstimationPerMonth(BigDecimal totalEstimationPerMonth) {
            this.totalEstimationPerMonth = totalEstimationPerMonth;
            this.__explicitlySet__.add("totalEstimationPerMonth");
            return this;
        }

        public Builder totalEstimationPerMonthBySubscription(BigDecimal totalEstimationPerMonthBySubscription) {
            this.totalEstimationPerMonthBySubscription = totalEstimationPerMonthBySubscription;
            this.__explicitlySet__.add("totalEstimationPerMonthBySubscription");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public CostEstimation build() {
            CostEstimation model = new CostEstimation(this.compute, this.storage, this.osImage, this.currencyCode, this.totalEstimationPerMonth, this.totalEstimationPerMonthBySubscription, this.subscriptionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CostEstimation model) {
            if (model.wasPropertyExplicitlySet("compute")) {
                this.compute(model.getCompute());
            }
            if (model.wasPropertyExplicitlySet("storage")) {
                this.storage(model.getStorage());
            }
            if (model.wasPropertyExplicitlySet("osImage")) {
                this.osImage(model.getOsImage());
            }
            if (model.wasPropertyExplicitlySet("currencyCode")) {
                this.currencyCode(model.getCurrencyCode());
            }
            if (model.wasPropertyExplicitlySet("totalEstimationPerMonth")) {
                this.totalEstimationPerMonth(model.getTotalEstimationPerMonth());
            }
            if (model.wasPropertyExplicitlySet("totalEstimationPerMonthBySubscription")) {
                this.totalEstimationPerMonthBySubscription(model.getTotalEstimationPerMonthBySubscription());
            }
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            return this;
        }
    }
}

