/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations;

import com.oracle.bmc.cloudmigrations.Migration;
import com.oracle.bmc.cloudmigrations.model.AvailableShapeSummary;
import com.oracle.bmc.cloudmigrations.model.MigrationAssetSummary;
import com.oracle.bmc.cloudmigrations.model.MigrationPlanSummary;
import com.oracle.bmc.cloudmigrations.model.MigrationSummary;
import com.oracle.bmc.cloudmigrations.model.ReplicationScheduleSummary;
import com.oracle.bmc.cloudmigrations.model.TargetAssetSummary;
import com.oracle.bmc.cloudmigrations.model.WorkRequestError;
import com.oracle.bmc.cloudmigrations.model.WorkRequestLogEntry;
import com.oracle.bmc.cloudmigrations.model.WorkRequestSummary;
import com.oracle.bmc.cloudmigrations.requests.ListAvailableShapesRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationAssetsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationPlansRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListReplicationSchedulesRequest;
import com.oracle.bmc.cloudmigrations.requests.ListTargetAssetsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestsRequest;
import com.oracle.bmc.cloudmigrations.responses.ListAvailableShapesResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationAssetsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationPlansResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListReplicationSchedulesResponse;
import com.oracle.bmc.cloudmigrations.responses.ListTargetAssetsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class MigrationPaginators {
    private final Migration client;

    public MigrationPaginators(Migration client) {
        this.client = client;
    }

    public Iterable<ListAvailableShapesResponse> listAvailableShapesResponseIterator(final ListAvailableShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAvailableShapesRequest.Builder>(){

            @Override
            public ListAvailableShapesRequest.Builder get() {
                return ListAvailableShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAvailableShapesResponse, String>(){

            @Override
            public String apply(ListAvailableShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAvailableShapesRequest.Builder>, ListAvailableShapesRequest>(){

            @Override
            public ListAvailableShapesRequest apply(RequestBuilderAndToken<ListAvailableShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAvailableShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAvailableShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAvailableShapesRequest, ListAvailableShapesResponse>(){

            @Override
            public ListAvailableShapesResponse apply(ListAvailableShapesRequest request) {
                return MigrationPaginators.this.client.listAvailableShapes(request);
            }
        });
    }

    public Iterable<AvailableShapeSummary> listAvailableShapesRecordIterator(final ListAvailableShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAvailableShapesRequest.Builder>(){

            @Override
            public ListAvailableShapesRequest.Builder get() {
                return ListAvailableShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAvailableShapesResponse, String>(){

            @Override
            public String apply(ListAvailableShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAvailableShapesRequest.Builder>, ListAvailableShapesRequest>(){

            @Override
            public ListAvailableShapesRequest apply(RequestBuilderAndToken<ListAvailableShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAvailableShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAvailableShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAvailableShapesRequest, ListAvailableShapesResponse>(){

            @Override
            public ListAvailableShapesResponse apply(ListAvailableShapesRequest request) {
                return MigrationPaginators.this.client.listAvailableShapes(request);
            }
        }, (Function)new Function<ListAvailableShapesResponse, List<AvailableShapeSummary>>(){

            @Override
            public List<AvailableShapeSummary> apply(ListAvailableShapesResponse response) {
                return response.getAvailableShapesCollection().getItems();
            }
        });
    }

    public Iterable<ListMigrationAssetsResponse> listMigrationAssetsResponseIterator(final ListMigrationAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationAssetsRequest.Builder>(){

            @Override
            public ListMigrationAssetsRequest.Builder get() {
                return ListMigrationAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationAssetsResponse, String>(){

            @Override
            public String apply(ListMigrationAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationAssetsRequest.Builder>, ListMigrationAssetsRequest>(){

            @Override
            public ListMigrationAssetsRequest apply(RequestBuilderAndToken<ListMigrationAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationAssetsRequest, ListMigrationAssetsResponse>(){

            @Override
            public ListMigrationAssetsResponse apply(ListMigrationAssetsRequest request) {
                return MigrationPaginators.this.client.listMigrationAssets(request);
            }
        });
    }

    public Iterable<MigrationAssetSummary> listMigrationAssetsRecordIterator(final ListMigrationAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationAssetsRequest.Builder>(){

            @Override
            public ListMigrationAssetsRequest.Builder get() {
                return ListMigrationAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationAssetsResponse, String>(){

            @Override
            public String apply(ListMigrationAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationAssetsRequest.Builder>, ListMigrationAssetsRequest>(){

            @Override
            public ListMigrationAssetsRequest apply(RequestBuilderAndToken<ListMigrationAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationAssetsRequest, ListMigrationAssetsResponse>(){

            @Override
            public ListMigrationAssetsResponse apply(ListMigrationAssetsRequest request) {
                return MigrationPaginators.this.client.listMigrationAssets(request);
            }
        }, (Function)new Function<ListMigrationAssetsResponse, List<MigrationAssetSummary>>(){

            @Override
            public List<MigrationAssetSummary> apply(ListMigrationAssetsResponse response) {
                return response.getMigrationAssetCollection().getItems();
            }
        });
    }

    public Iterable<ListMigrationPlansResponse> listMigrationPlansResponseIterator(final ListMigrationPlansRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationPlansRequest.Builder>(){

            @Override
            public ListMigrationPlansRequest.Builder get() {
                return ListMigrationPlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationPlansResponse, String>(){

            @Override
            public String apply(ListMigrationPlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationPlansRequest.Builder>, ListMigrationPlansRequest>(){

            @Override
            public ListMigrationPlansRequest apply(RequestBuilderAndToken<ListMigrationPlansRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationPlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationPlansRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationPlansRequest, ListMigrationPlansResponse>(){

            @Override
            public ListMigrationPlansResponse apply(ListMigrationPlansRequest request) {
                return MigrationPaginators.this.client.listMigrationPlans(request);
            }
        });
    }

    public Iterable<MigrationPlanSummary> listMigrationPlansRecordIterator(final ListMigrationPlansRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationPlansRequest.Builder>(){

            @Override
            public ListMigrationPlansRequest.Builder get() {
                return ListMigrationPlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationPlansResponse, String>(){

            @Override
            public String apply(ListMigrationPlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationPlansRequest.Builder>, ListMigrationPlansRequest>(){

            @Override
            public ListMigrationPlansRequest apply(RequestBuilderAndToken<ListMigrationPlansRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationPlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationPlansRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationPlansRequest, ListMigrationPlansResponse>(){

            @Override
            public ListMigrationPlansResponse apply(ListMigrationPlansRequest request) {
                return MigrationPaginators.this.client.listMigrationPlans(request);
            }
        }, (Function)new Function<ListMigrationPlansResponse, List<MigrationPlanSummary>>(){

            @Override
            public List<MigrationPlanSummary> apply(ListMigrationPlansResponse response) {
                return response.getMigrationPlanCollection().getItems();
            }
        });
    }

    public Iterable<ListMigrationsResponse> listMigrationsResponseIterator(final ListMigrationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            @Override
            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            @Override
            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            @Override
            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            @Override
            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return MigrationPaginators.this.client.listMigrations(request);
            }
        });
    }

    public Iterable<MigrationSummary> listMigrationsRecordIterator(final ListMigrationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMigrationsRequest.Builder>(){

            @Override
            public ListMigrationsRequest.Builder get() {
                return ListMigrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMigrationsResponse, String>(){

            @Override
            public String apply(ListMigrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMigrationsRequest.Builder>, ListMigrationsRequest>(){

            @Override
            public ListMigrationsRequest apply(RequestBuilderAndToken<ListMigrationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMigrationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMigrationsRequest, ListMigrationsResponse>(){

            @Override
            public ListMigrationsResponse apply(ListMigrationsRequest request) {
                return MigrationPaginators.this.client.listMigrations(request);
            }
        }, (Function)new Function<ListMigrationsResponse, List<MigrationSummary>>(){

            @Override
            public List<MigrationSummary> apply(ListMigrationsResponse response) {
                return response.getMigrationCollection().getItems();
            }
        });
    }

    public Iterable<ListReplicationSchedulesResponse> listReplicationSchedulesResponseIterator(final ListReplicationSchedulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationSchedulesRequest.Builder>(){

            @Override
            public ListReplicationSchedulesRequest.Builder get() {
                return ListReplicationSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationSchedulesResponse, String>(){

            @Override
            public String apply(ListReplicationSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationSchedulesRequest.Builder>, ListReplicationSchedulesRequest>(){

            @Override
            public ListReplicationSchedulesRequest apply(RequestBuilderAndToken<ListReplicationSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationSchedulesRequest, ListReplicationSchedulesResponse>(){

            @Override
            public ListReplicationSchedulesResponse apply(ListReplicationSchedulesRequest request) {
                return MigrationPaginators.this.client.listReplicationSchedules(request);
            }
        });
    }

    public Iterable<ReplicationScheduleSummary> listReplicationSchedulesRecordIterator(final ListReplicationSchedulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationSchedulesRequest.Builder>(){

            @Override
            public ListReplicationSchedulesRequest.Builder get() {
                return ListReplicationSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationSchedulesResponse, String>(){

            @Override
            public String apply(ListReplicationSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationSchedulesRequest.Builder>, ListReplicationSchedulesRequest>(){

            @Override
            public ListReplicationSchedulesRequest apply(RequestBuilderAndToken<ListReplicationSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationSchedulesRequest, ListReplicationSchedulesResponse>(){

            @Override
            public ListReplicationSchedulesResponse apply(ListReplicationSchedulesRequest request) {
                return MigrationPaginators.this.client.listReplicationSchedules(request);
            }
        }, (Function)new Function<ListReplicationSchedulesResponse, List<ReplicationScheduleSummary>>(){

            @Override
            public List<ReplicationScheduleSummary> apply(ListReplicationSchedulesResponse response) {
                return response.getReplicationScheduleCollection().getItems();
            }
        });
    }

    public Iterable<ListTargetAssetsResponse> listTargetAssetsResponseIterator(final ListTargetAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTargetAssetsRequest.Builder>(){

            @Override
            public ListTargetAssetsRequest.Builder get() {
                return ListTargetAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTargetAssetsResponse, String>(){

            @Override
            public String apply(ListTargetAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTargetAssetsRequest.Builder>, ListTargetAssetsRequest>(){

            @Override
            public ListTargetAssetsRequest apply(RequestBuilderAndToken<ListTargetAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTargetAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTargetAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTargetAssetsRequest, ListTargetAssetsResponse>(){

            @Override
            public ListTargetAssetsResponse apply(ListTargetAssetsRequest request) {
                return MigrationPaginators.this.client.listTargetAssets(request);
            }
        });
    }

    public Iterable<TargetAssetSummary> listTargetAssetsRecordIterator(final ListTargetAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTargetAssetsRequest.Builder>(){

            @Override
            public ListTargetAssetsRequest.Builder get() {
                return ListTargetAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTargetAssetsResponse, String>(){

            @Override
            public String apply(ListTargetAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTargetAssetsRequest.Builder>, ListTargetAssetsRequest>(){

            @Override
            public ListTargetAssetsRequest apply(RequestBuilderAndToken<ListTargetAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTargetAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTargetAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTargetAssetsRequest, ListTargetAssetsResponse>(){

            @Override
            public ListTargetAssetsResponse apply(ListTargetAssetsRequest request) {
                return MigrationPaginators.this.client.listTargetAssets(request);
            }
        }, (Function)new Function<ListTargetAssetsResponse, List<TargetAssetSummary>>(){

            @Override
            public List<TargetAssetSummary> apply(ListTargetAssetsResponse response) {
                return response.getTargetAssetCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return MigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return MigrationPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return MigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return MigrationPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return MigrationPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return MigrationPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

