/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudmigrations.Migration;
import com.oracle.bmc.cloudmigrations.MigrationAsyncClient;
import com.oracle.bmc.cloudmigrations.MigrationPaginators;
import com.oracle.bmc.cloudmigrations.MigrationWaiters;
import com.oracle.bmc.cloudmigrations.model.AvailableShapesCollection;
import com.oracle.bmc.cloudmigrations.model.MigrationAsset;
import com.oracle.bmc.cloudmigrations.model.MigrationAssetCollection;
import com.oracle.bmc.cloudmigrations.model.MigrationCollection;
import com.oracle.bmc.cloudmigrations.model.MigrationPlan;
import com.oracle.bmc.cloudmigrations.model.MigrationPlanCollection;
import com.oracle.bmc.cloudmigrations.model.ReplicationProgress;
import com.oracle.bmc.cloudmigrations.model.ReplicationSchedule;
import com.oracle.bmc.cloudmigrations.model.ReplicationScheduleCollection;
import com.oracle.bmc.cloudmigrations.model.TargetAsset;
import com.oracle.bmc.cloudmigrations.model.TargetAssetCollection;
import com.oracle.bmc.cloudmigrations.model.WorkRequest;
import com.oracle.bmc.cloudmigrations.model.WorkRequestErrorCollection;
import com.oracle.bmc.cloudmigrations.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.cloudmigrations.model.WorkRequestSummaryCollection;
import com.oracle.bmc.cloudmigrations.requests.CancelWorkRequestRequest;
import com.oracle.bmc.cloudmigrations.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.cloudmigrations.requests.ChangeMigrationPlanCompartmentRequest;
import com.oracle.bmc.cloudmigrations.requests.ChangeReplicationScheduleCompartmentRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.ExecuteMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.ExportMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.GetReplicationProgressRequest;
import com.oracle.bmc.cloudmigrations.requests.GetReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.GetTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudmigrations.requests.ImportMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.ListAvailableShapesRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationAssetsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationPlansRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListReplicationSchedulesRequest;
import com.oracle.bmc.cloudmigrations.requests.ListTargetAssetsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestsRequest;
import com.oracle.bmc.cloudmigrations.requests.RefreshMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.RefreshMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.RefreshMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.StartAssetReplicationRequest;
import com.oracle.bmc.cloudmigrations.requests.StartMigrationReplicationRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.responses.CancelWorkRequestResponse;
import com.oracle.bmc.cloudmigrations.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.cloudmigrations.responses.ChangeMigrationPlanCompartmentResponse;
import com.oracle.bmc.cloudmigrations.responses.ChangeReplicationScheduleCompartmentResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.ExecuteMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.ExportMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.GetReplicationProgressResponse;
import com.oracle.bmc.cloudmigrations.responses.GetReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.GetTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.GetWorkRequestResponse;
import com.oracle.bmc.cloudmigrations.responses.ImportMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.ListAvailableShapesResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationAssetsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationPlansResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListReplicationSchedulesResponse;
import com.oracle.bmc.cloudmigrations.responses.ListTargetAssetsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestsResponse;
import com.oracle.bmc.cloudmigrations.responses.RefreshMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.RefreshMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.RefreshMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.StartAssetReplicationResponse;
import com.oracle.bmc.cloudmigrations.responses.StartMigrationReplicationResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateTargetAssetResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationClient
extends BaseSyncClient
implements Migration {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MIGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudmigration.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(MigrationAsyncClient.class);
    private final MigrationWaiters waiters;
    private final MigrationPaginators paginators;

    private MigrationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Migration-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new MigrationWaiters(executorService, this);
        this.paginators = new MigrationPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("Migration", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220919").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeMigrationCompartmentResponse changeMigrationCompartment(ChangeMigrationCompartmentRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMigrationCompartmentDetails(), "changeMigrationCompartmentDetails is required");
        return (ChangeMigrationCompartmentResponse)this.clientCall(request, ChangeMigrationCompartmentResponse::builder).logger(LOG, "changeMigrationCompartment").serviceDetails("Migration", "ChangeMigrationCompartment", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/ChangeMigrationCompartment").method(Method.POST).requestBuilder(ChangeMigrationCompartmentRequest::builder).basePath("/20220919").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMigrationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMigrationCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeMigrationPlanCompartmentResponse changeMigrationPlanCompartment(ChangeMigrationPlanCompartmentRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMigrationPlanCompartmentDetails(), "changeMigrationPlanCompartmentDetails is required");
        return (ChangeMigrationPlanCompartmentResponse)this.clientCall(request, ChangeMigrationPlanCompartmentResponse::builder).logger(LOG, "changeMigrationPlanCompartment").serviceDetails("Migration", "ChangeMigrationPlanCompartment", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/ChangeMigrationPlanCompartment").method(Method.POST).requestBuilder(ChangeMigrationPlanCompartmentRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeMigrationPlanCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeMigrationPlanCompartmentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeReplicationScheduleCompartmentResponse changeReplicationScheduleCompartment(ChangeReplicationScheduleCompartmentRequest request) {
        Validate.notBlank((String)request.getReplicationScheduleId(), (String)"replicationScheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeReplicationScheduleCompartmentDetails(), "changeReplicationScheduleCompartmentDetails is required");
        return (ChangeReplicationScheduleCompartmentResponse)this.clientCall(request, ChangeReplicationScheduleCompartmentResponse::builder).logger(LOG, "changeReplicationScheduleCompartment").serviceDetails("Migration", "ChangeReplicationScheduleCompartment", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/ReplicationSchedule/ChangeReplicationScheduleCompartment").method(Method.POST).requestBuilder(ChangeReplicationScheduleCompartmentRequest::builder).basePath("/20220919").appendPathParam("replicationSchedules").appendPathParam(request.getReplicationScheduleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeReplicationScheduleCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeReplicationScheduleCompartmentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMigrationResponse createMigration(CreateMigrationRequest request) {
        Objects.requireNonNull(request.getCreateMigrationDetails(), "createMigrationDetails is required");
        return (CreateMigrationResponse)this.clientCall(request, CreateMigrationResponse::builder).logger(LOG, "createMigration").serviceDetails("Migration", "CreateMigration", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/CreateMigration").method(Method.POST).requestBuilder(CreateMigrationRequest::builder).basePath("/20220919").appendPathParam("migrations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.cloudmigrations.model.Migration.class, CreateMigrationResponse.Builder::migration).handleResponseHeaderString("etag", CreateMigrationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMigrationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMigrationAssetResponse createMigrationAsset(CreateMigrationAssetRequest request) {
        Objects.requireNonNull(request.getCreateMigrationAssetDetails(), "createMigrationAssetDetails is required");
        return (CreateMigrationAssetResponse)this.clientCall(request, CreateMigrationAssetResponse::builder).logger(LOG, "createMigrationAsset").serviceDetails("Migration", "CreateMigrationAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/CreateMigrationAsset").method(Method.POST).requestBuilder(CreateMigrationAssetRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MigrationAsset.class, CreateMigrationAssetResponse.Builder::migrationAsset).handleResponseHeaderString("etag", CreateMigrationAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMigrationAssetResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateMigrationAssetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateMigrationAssetResponse.Builder::location).handleResponseHeaderString("content-location", CreateMigrationAssetResponse.Builder::contentLocation).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateMigrationPlanResponse createMigrationPlan(CreateMigrationPlanRequest request) {
        Objects.requireNonNull(request.getCreateMigrationPlanDetails(), "createMigrationPlanDetails is required");
        return (CreateMigrationPlanResponse)this.clientCall(request, CreateMigrationPlanResponse::builder).logger(LOG, "createMigrationPlan").serviceDetails("Migration", "CreateMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/CreateMigrationPlan").method(Method.POST).requestBuilder(CreateMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MigrationPlan.class, CreateMigrationPlanResponse.Builder::migrationPlan).handleResponseHeaderString("etag", CreateMigrationPlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMigrationPlanResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateMigrationPlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateMigrationPlanResponse.Builder::location).handleResponseHeaderString("content-location", CreateMigrationPlanResponse.Builder::contentLocation).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateReplicationScheduleResponse createReplicationSchedule(CreateReplicationScheduleRequest request) {
        Objects.requireNonNull(request.getCreateReplicationScheduleDetails(), "createReplicationScheduleDetails is required");
        return (CreateReplicationScheduleResponse)this.clientCall(request, CreateReplicationScheduleResponse::builder).logger(LOG, "createReplicationSchedule").serviceDetails("Migration", "CreateReplicationSchedule", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/ReplicationSchedule/CreateReplicationSchedule").method(Method.POST).requestBuilder(CreateReplicationScheduleRequest::builder).basePath("/20220919").appendPathParam("replicationSchedules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ReplicationSchedule.class, CreateReplicationScheduleResponse.Builder::replicationSchedule).handleResponseHeaderString("etag", CreateReplicationScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateReplicationScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateReplicationScheduleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateReplicationScheduleResponse.Builder::location).handleResponseHeaderString("content-location", CreateReplicationScheduleResponse.Builder::contentLocation).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateTargetAssetResponse createTargetAsset(CreateTargetAssetRequest request) {
        Objects.requireNonNull(request.getCreateTargetAssetDetails(), "createTargetAssetDetails is required");
        return (CreateTargetAssetResponse)this.clientCall(request, CreateTargetAssetResponse::builder).logger(LOG, "createTargetAsset").serviceDetails("Migration", "CreateTargetAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/TargetAsset/CreateTargetAsset").method(Method.POST).requestBuilder(CreateTargetAssetRequest::builder).basePath("/20220919").appendPathParam("targetAssets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetAsset.class, CreateTargetAssetResponse.Builder::targetAsset).handleResponseHeaderString("etag", CreateTargetAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTargetAssetResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateTargetAssetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateTargetAssetResponse.Builder::location).handleResponseHeaderString("content-location", CreateTargetAssetResponse.Builder::contentLocation).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMigrationResponse deleteMigration(DeleteMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (DeleteMigrationResponse)this.clientCall(request, DeleteMigrationResponse::builder).logger(LOG, "deleteMigration").serviceDetails("Migration", "DeleteMigration", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/DeleteMigration").method(Method.DELETE).requestBuilder(DeleteMigrationRequest::builder).basePath("/20220919").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMigrationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMigrationAssetResponse deleteMigrationAsset(DeleteMigrationAssetRequest request) {
        Validate.notBlank((String)request.getMigrationAssetId(), (String)"migrationAssetId must not be blank", (Object[])new Object[0]);
        return (DeleteMigrationAssetResponse)this.clientCall(request, DeleteMigrationAssetResponse::builder).logger(LOG, "deleteMigrationAsset").serviceDetails("Migration", "DeleteMigrationAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/DeleteMigrationAsset").method(Method.DELETE).requestBuilder(DeleteMigrationAssetRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendPathParam(request.getMigrationAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMigrationAssetResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteMigrationAssetResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteMigrationPlanResponse deleteMigrationPlan(DeleteMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        return (DeleteMigrationPlanResponse)this.clientCall(request, DeleteMigrationPlanResponse::builder).logger(LOG, "deleteMigrationPlan").serviceDetails("Migration", "DeleteMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/DeleteMigrationPlan").method(Method.DELETE).requestBuilder(DeleteMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMigrationPlanResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteMigrationPlanResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteReplicationScheduleResponse deleteReplicationSchedule(DeleteReplicationScheduleRequest request) {
        Validate.notBlank((String)request.getReplicationScheduleId(), (String)"replicationScheduleId must not be blank", (Object[])new Object[0]);
        return (DeleteReplicationScheduleResponse)this.clientCall(request, DeleteReplicationScheduleResponse::builder).logger(LOG, "deleteReplicationSchedule").serviceDetails("Migration", "DeleteReplicationSchedule", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/ReplicationSchedule/DeleteReplicationSchedule").method(Method.DELETE).requestBuilder(DeleteReplicationScheduleRequest::builder).basePath("/20220919").appendPathParam("replicationSchedules").appendPathParam(request.getReplicationScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteReplicationScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteReplicationScheduleResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteTargetAssetResponse deleteTargetAsset(DeleteTargetAssetRequest request) {
        Validate.notBlank((String)request.getTargetAssetId(), (String)"targetAssetId must not be blank", (Object[])new Object[0]);
        return (DeleteTargetAssetResponse)this.clientCall(request, DeleteTargetAssetResponse::builder).logger(LOG, "deleteTargetAsset").serviceDetails("Migration", "DeleteTargetAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/TargetAsset/DeleteTargetAsset").method(Method.DELETE).requestBuilder(DeleteTargetAssetRequest::builder).basePath("/20220919").appendPathParam("targetAssets").appendPathParam(request.getTargetAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTargetAssetResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteTargetAssetResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExecuteMigrationPlanResponse executeMigrationPlan(ExecuteMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        return (ExecuteMigrationPlanResponse)this.clientCall(request, ExecuteMigrationPlanResponse::builder).logger(LOG, "executeMigrationPlan").serviceDetails("Migration", "ExecuteMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/ExecuteMigrationPlan").method(Method.POST).requestBuilder(ExecuteMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).appendPathParam("actions").appendPathParam("execute").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", ExecuteMigrationPlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ExecuteMigrationPlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExportMigrationPlanResponse exportMigrationPlan(ExportMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        return (ExportMigrationPlanResponse)this.clientCall(request, ExportMigrationPlanResponse::builder).logger(LOG, "exportMigrationPlan").serviceDetails("Migration", "ExportMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/ExportMigrationPlan").method(Method.GET).requestBuilder(ExportMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"text/csv"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, ExportMigrationPlanResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", ExportMigrationPlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMigrationResponse getMigration(GetMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (GetMigrationResponse)this.clientCall(request, GetMigrationResponse::builder).logger(LOG, "getMigration").serviceDetails("Migration", "GetMigration", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/GetMigration").method(Method.GET).requestBuilder(GetMigrationRequest::builder).basePath("/20220919").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.cloudmigrations.model.Migration.class, GetMigrationResponse.Builder::migration).handleResponseHeaderString("etag", GetMigrationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMigrationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMigrationAssetResponse getMigrationAsset(GetMigrationAssetRequest request) {
        Validate.notBlank((String)request.getMigrationAssetId(), (String)"migrationAssetId must not be blank", (Object[])new Object[0]);
        return (GetMigrationAssetResponse)this.clientCall(request, GetMigrationAssetResponse::builder).logger(LOG, "getMigrationAsset").serviceDetails("Migration", "GetMigrationAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/GetMigrationAsset").method(Method.GET).requestBuilder(GetMigrationAssetRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendPathParam(request.getMigrationAssetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationAsset.class, GetMigrationAssetResponse.Builder::migrationAsset).handleResponseHeaderString("etag", GetMigrationAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMigrationAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMigrationPlanResponse getMigrationPlan(GetMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        return (GetMigrationPlanResponse)this.clientCall(request, GetMigrationPlanResponse::builder).logger(LOG, "getMigrationPlan").serviceDetails("Migration", "GetMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/GetMigrationPlan").method(Method.GET).requestBuilder(GetMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationPlan.class, GetMigrationPlanResponse.Builder::migrationPlan).handleResponseHeaderString("etag", GetMigrationPlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMigrationPlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetReplicationProgressResponse getReplicationProgress(GetReplicationProgressRequest request) {
        Validate.notBlank((String)request.getMigrationAssetId(), (String)"migrationAssetId must not be blank", (Object[])new Object[0]);
        return (GetReplicationProgressResponse)this.clientCall(request, GetReplicationProgressResponse::builder).logger(LOG, "getReplicationProgress").serviceDetails("Migration", "GetReplicationProgress", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/GetReplicationProgress").method(Method.GET).requestBuilder(GetReplicationProgressRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendPathParam(request.getMigrationAssetId()).appendPathParam("actions").appendPathParam("replicationProgress").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReplicationProgress.class, GetReplicationProgressResponse.Builder::replicationProgress).handleResponseHeaderString("opc-request-id", GetReplicationProgressResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetReplicationScheduleResponse getReplicationSchedule(GetReplicationScheduleRequest request) {
        Validate.notBlank((String)request.getReplicationScheduleId(), (String)"replicationScheduleId must not be blank", (Object[])new Object[0]);
        return (GetReplicationScheduleResponse)this.clientCall(request, GetReplicationScheduleResponse::builder).logger(LOG, "getReplicationSchedule").serviceDetails("Migration", "GetReplicationSchedule", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/ReplicationSchedule/GetReplicationSchedule").method(Method.GET).requestBuilder(GetReplicationScheduleRequest::builder).basePath("/20220919").appendPathParam("replicationSchedules").appendPathParam(request.getReplicationScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReplicationSchedule.class, GetReplicationScheduleResponse.Builder::replicationSchedule).handleResponseHeaderString("etag", GetReplicationScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReplicationScheduleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTargetAssetResponse getTargetAsset(GetTargetAssetRequest request) {
        Validate.notBlank((String)request.getTargetAssetId(), (String)"targetAssetId must not be blank", (Object[])new Object[0]);
        return (GetTargetAssetResponse)this.clientCall(request, GetTargetAssetResponse::builder).logger(LOG, "getTargetAsset").serviceDetails("Migration", "GetTargetAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/TargetAsset/GetTargetAsset").method(Method.GET).requestBuilder(GetTargetAssetRequest::builder).basePath("/20220919").appendPathParam("targetAssets").appendPathParam(request.getTargetAssetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetAsset.class, GetTargetAssetResponse.Builder::targetAsset).handleResponseHeaderString("etag", GetTargetAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTargetAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Migration", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220919").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ImportMigrationPlanResponse importMigrationPlan(ImportMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportMigrationPlanDetails(), "importMigrationPlanDetails is required");
        return (ImportMigrationPlanResponse)this.clientCall(request, ImportMigrationPlanResponse::builder).logger(LOG, "importMigrationPlan").serviceDetails("Migration", "ImportMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/ImportMigrationPlan").method(Method.POST).requestBuilder(ImportMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).appendPathParam("actions").appendPathParam("import").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("opc-work-request-id", ImportMigrationPlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportMigrationPlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAvailableShapesResponse listAvailableShapes(ListAvailableShapesRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        return (ListAvailableShapesResponse)this.clientCall(request, ListAvailableShapesResponse::builder).logger(LOG, "listAvailableShapes").serviceDetails("Migration", "ListAvailableShapes", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/AvailableShapesCollection/ListAvailableShapes").method(Method.GET).requestBuilder(ListAvailableShapesRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).appendPathParam("availableShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dvhHostId", (Object)request.getDvhHostId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("reservedCapacityId", (Object)request.getReservedCapacityId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AvailableShapesCollection.class, ListAvailableShapesResponse.Builder::availableShapesCollection).handleResponseHeaderString("opc-request-id", ListAvailableShapesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAvailableShapesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMigrationAssetsResponse listMigrationAssets(ListMigrationAssetsRequest request) {
        return (ListMigrationAssetsResponse)this.clientCall(request, ListMigrationAssetsResponse::builder).logger(LOG, "listMigrationAssets").serviceDetails("Migration", "ListMigrationAssets", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAssetCollection/ListMigrationAssets").method(Method.GET).requestBuilder(ListMigrationAssetsRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendQueryParam("migrationId", (Object)request.getMigrationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("migrationAssetId", (Object)request.getMigrationAssetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationAssetCollection.class, ListMigrationAssetsResponse.Builder::migrationAssetCollection).handleResponseHeaderString("opc-request-id", ListMigrationAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationAssetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMigrationPlansResponse listMigrationPlans(ListMigrationPlansRequest request) {
        return (ListMigrationPlansResponse)this.clientCall(request, ListMigrationPlansResponse::builder).logger(LOG, "listMigrationPlans").serviceDetails("Migration", "ListMigrationPlans", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlanCollection/ListMigrationPlans").method(Method.GET).requestBuilder(ListMigrationPlansRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("migrationId", (Object)request.getMigrationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("migrationPlanId", (Object)request.getMigrationPlanId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationPlanCollection.class, ListMigrationPlansResponse.Builder::migrationPlanCollection).handleResponseHeaderString("opc-request-id", ListMigrationPlansResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationPlansResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMigrationsResponse listMigrations(ListMigrationsRequest request) {
        return (ListMigrationsResponse)this.clientCall(request, ListMigrationsResponse::builder).logger(LOG, "listMigrations").serviceDetails("Migration", "ListMigrations", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationCollection/ListMigrations").method(Method.GET).requestBuilder(ListMigrationsRequest::builder).basePath("/20220919").appendPathParam("migrations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("migrationId", (Object)request.getMigrationId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MigrationCollection.class, ListMigrationsResponse.Builder::migrationCollection).handleResponseHeaderString("opc-request-id", ListMigrationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListReplicationSchedulesResponse listReplicationSchedules(ListReplicationSchedulesRequest request) {
        return (ListReplicationSchedulesResponse)this.clientCall(request, ListReplicationSchedulesResponse::builder).logger(LOG, "listReplicationSchedules").serviceDetails("Migration", "ListReplicationSchedules", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/ReplicationScheduleCollection/ListReplicationSchedules").method(Method.GET).requestBuilder(ListReplicationSchedulesRequest::builder).basePath("/20220919").appendPathParam("replicationSchedules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("replicationScheduleId", (Object)request.getReplicationScheduleId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReplicationScheduleCollection.class, ListReplicationSchedulesResponse.Builder::replicationScheduleCollection).handleResponseHeaderString("opc-request-id", ListReplicationSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReplicationSchedulesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTargetAssetsResponse listTargetAssets(ListTargetAssetsRequest request) {
        return (ListTargetAssetsResponse)this.clientCall(request, ListTargetAssetsResponse::builder).logger(LOG, "listTargetAssets").serviceDetails("Migration", "ListTargetAssets", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/TargetAssetCollection/ListTargetAssets").method(Method.GET).requestBuilder(ListTargetAssetsRequest::builder).basePath("/20220919").appendPathParam("targetAssets").appendQueryParam("migrationPlanId", (Object)request.getMigrationPlanId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("targetAssetId", (Object)request.getTargetAssetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetAssetCollection.class, ListTargetAssetsResponse.Builder::targetAssetCollection).handleResponseHeaderString("opc-request-id", ListTargetAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetAssetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Migration", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220919").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Migration", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220919").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Migration", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220919").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RefreshMigrationResponse refreshMigration(RefreshMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (RefreshMigrationResponse)this.clientCall(request, RefreshMigrationResponse::builder).logger(LOG, "refreshMigration").serviceDetails("Migration", "RefreshMigration", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/RefreshMigration").method(Method.POST).requestBuilder(RefreshMigrationRequest::builder).basePath("/20220919").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("refresh").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", RefreshMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshMigrationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RefreshMigrationAssetResponse refreshMigrationAsset(RefreshMigrationAssetRequest request) {
        Validate.notBlank((String)request.getMigrationAssetId(), (String)"migrationAssetId must not be blank", (Object[])new Object[0]);
        return (RefreshMigrationAssetResponse)this.clientCall(request, RefreshMigrationAssetResponse::builder).logger(LOG, "refreshMigrationAsset").serviceDetails("Migration", "RefreshMigrationAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/RefreshMigrationAsset").method(Method.POST).requestBuilder(RefreshMigrationAssetRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendPathParam(request.getMigrationAssetId()).appendPathParam("actions").appendPathParam("refresh").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", RefreshMigrationAssetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshMigrationAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RefreshMigrationPlanResponse refreshMigrationPlan(RefreshMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        return (RefreshMigrationPlanResponse)this.clientCall(request, RefreshMigrationPlanResponse::builder).logger(LOG, "refreshMigrationPlan").serviceDetails("Migration", "RefreshMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/RefreshMigrationPlan").method(Method.POST).requestBuilder(RefreshMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).appendPathParam("actions").appendPathParam("refresh").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", RefreshMigrationPlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshMigrationPlanResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public StartAssetReplicationResponse startAssetReplication(StartAssetReplicationRequest request) {
        Validate.notBlank((String)request.getMigrationAssetId(), (String)"migrationAssetId must not be blank", (Object[])new Object[0]);
        return (StartAssetReplicationResponse)this.clientCall(request, StartAssetReplicationResponse::builder).logger(LOG, "startAssetReplication").serviceDetails("Migration", "StartAssetReplication", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/StartAssetReplication").method(Method.POST).requestBuilder(StartAssetReplicationRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendPathParam(request.getMigrationAssetId()).appendPathParam("actions").appendPathParam("startAssetReplication").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartAssetReplicationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartAssetReplicationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public StartMigrationReplicationResponse startMigrationReplication(StartMigrationReplicationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (StartMigrationReplicationResponse)this.clientCall(request, StartMigrationReplicationResponse::builder).logger(LOG, "startMigrationReplication").serviceDetails("Migration", "StartMigrationReplication", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/StartMigrationReplication").method(Method.POST).requestBuilder(StartMigrationReplicationRequest::builder).basePath("/20220919").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("startMigrationReplication").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartMigrationReplicationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartMigrationReplicationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMigrationResponse updateMigration(UpdateMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMigrationDetails(), "updateMigrationDetails is required");
        return (UpdateMigrationResponse)this.clientCall(request, UpdateMigrationResponse::builder).logger(LOG, "updateMigration").serviceDetails("Migration", "UpdateMigration", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/Migration/UpdateMigration").method(Method.PUT).requestBuilder(UpdateMigrationRequest::builder).basePath("/20220919").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.cloudmigrations.model.Migration.class, UpdateMigrationResponse.Builder::migration).handleResponseHeaderString("etag", UpdateMigrationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMigrationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMigrationAssetResponse updateMigrationAsset(UpdateMigrationAssetRequest request) {
        Validate.notBlank((String)request.getMigrationAssetId(), (String)"migrationAssetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMigrationAssetDetails(), "updateMigrationAssetDetails is required");
        return (UpdateMigrationAssetResponse)this.clientCall(request, UpdateMigrationAssetResponse::builder).logger(LOG, "updateMigrationAsset").serviceDetails("Migration", "UpdateMigrationAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationAsset/UpdateMigrationAsset").method(Method.PUT).requestBuilder(UpdateMigrationAssetRequest::builder).basePath("/20220919").appendPathParam("migrationAssets").appendPathParam(request.getMigrationAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MigrationAsset.class, UpdateMigrationAssetResponse.Builder::migrationAsset).handleResponseHeaderString("etag", UpdateMigrationAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMigrationAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateMigrationPlanResponse updateMigrationPlan(UpdateMigrationPlanRequest request) {
        Validate.notBlank((String)request.getMigrationPlanId(), (String)"migrationPlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMigrationPlanDetails(), "updateMigrationPlanDetails is required");
        return (UpdateMigrationPlanResponse)this.clientCall(request, UpdateMigrationPlanResponse::builder).logger(LOG, "updateMigrationPlan").serviceDetails("Migration", "UpdateMigrationPlan", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/MigrationPlan/UpdateMigrationPlan").method(Method.PUT).requestBuilder(UpdateMigrationPlanRequest::builder).basePath("/20220919").appendPathParam("migrationPlans").appendPathParam(request.getMigrationPlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateMigrationPlanResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateMigrationPlanResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateReplicationScheduleResponse updateReplicationSchedule(UpdateReplicationScheduleRequest request) {
        Validate.notBlank((String)request.getReplicationScheduleId(), (String)"replicationScheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateReplicationScheduleDetails(), "updateReplicationScheduleDetails is required");
        return (UpdateReplicationScheduleResponse)this.clientCall(request, UpdateReplicationScheduleResponse::builder).logger(LOG, "updateReplicationSchedule").serviceDetails("Migration", "UpdateReplicationSchedule", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/ReplicationSchedule/UpdateReplicationSchedule").method(Method.PUT).requestBuilder(UpdateReplicationScheduleRequest::builder).basePath("/20220919").appendPathParam("replicationSchedules").appendPathParam(request.getReplicationScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateReplicationScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateReplicationScheduleResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateTargetAssetResponse updateTargetAsset(UpdateTargetAssetRequest request) {
        Validate.notBlank((String)request.getTargetAssetId(), (String)"targetAssetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTargetAssetDetails(), "updateTargetAssetDetails is required");
        return (UpdateTargetAssetResponse)this.clientCall(request, UpdateTargetAssetResponse::builder).logger(LOG, "updateTargetAsset").serviceDetails("Migration", "UpdateTargetAsset", "https://docs.oracle.com/iaas/api/#/en/ocm/20220919/TargetAsset/UpdateTargetAsset").method(Method.PUT).requestBuilder(UpdateTargetAssetRequest::builder).basePath("/20220919").appendPathParam("targetAssets").appendPathParam(request.getTargetAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateTargetAssetResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateTargetAssetResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public MigrationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public MigrationPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public MigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)MigrationClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(MigrationClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)MigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)MigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)MigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)MigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MigrationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public MigrationClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new MigrationClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

