/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.responses;

import com.oracle.bmc.cloudguard.model.DetectorCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDetectorsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private DetectorCollection detectorCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public DetectorCollection getDetectorCollection() {
        return this.detectorCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "detectorCollection"})
    private ListDetectorsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, DetectorCollection detectorCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.detectorCollection = detectorCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",detectorCollection=").append(String.valueOf((Object)this.detectorCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDetectorsResponse)) {
            return false;
        }
        ListDetectorsResponse other = (ListDetectorsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.detectorCollection, (Object)other.detectorCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.detectorCollection == null ? 43 : this.detectorCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListDetectorsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private DetectorCollection detectorCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder detectorCollection(DetectorCollection detectorCollection) {
            this.detectorCollection = detectorCollection;
            return this;
        }

        public Builder copy(ListDetectorsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.detectorCollection(o.getDetectorCollection());
            return this;
        }

        public ListDetectorsResponse build() {
            return new ListDetectorsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.detectorCollection);
        }
    }
}

