/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.responses;

import com.oracle.bmc.cloudguard.model.ManagedList;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetManagedListResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private ManagedList managedList;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ManagedList getManagedList() {
        return this.managedList;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "managedList"})
    private GetManagedListResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, ManagedList managedList) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.managedList = managedList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",managedList=").append(String.valueOf((Object)this.managedList));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetManagedListResponse)) {
            return false;
        }
        GetManagedListResponse other = (GetManagedListResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.managedList, (Object)other.managedList);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.managedList == null ? 43 : this.managedList.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetManagedListResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private ManagedList managedList;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder managedList(ManagedList managedList) {
            this.managedList = managedList;
            return this;
        }

        public Builder copy(GetManagedListResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.managedList(o.getManagedList());
            return this;
        }

        public GetManagedListResponse build() {
            return new GetManagedListResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.managedList);
        }
    }
}

