/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.UpdateManagedListDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateManagedListRequest
extends BmcRequest<UpdateManagedListDetails> {
    private String managedListId;
    private UpdateManagedListDetails updateManagedListDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedListId() {
        return this.managedListId;
    }

    public UpdateManagedListDetails getUpdateManagedListDetails() {
        return this.updateManagedListDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateManagedListDetails getBody$() {
        return this.updateManagedListDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedListId(this.managedListId).updateManagedListDetails(this.updateManagedListDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedListId=").append(String.valueOf(this.managedListId));
        sb.append(",updateManagedListDetails=").append(String.valueOf((Object)this.updateManagedListDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateManagedListRequest)) {
            return false;
        }
        UpdateManagedListRequest other = (UpdateManagedListRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedListId, other.managedListId) && Objects.equals((Object)this.updateManagedListDetails, (Object)other.updateManagedListDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedListId == null ? 43 : this.managedListId.hashCode());
        result = result * 59 + (this.updateManagedListDetails == null ? 43 : this.updateManagedListDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateManagedListRequest, UpdateManagedListDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedListId = null;
        private UpdateManagedListDetails updateManagedListDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedListId(String managedListId) {
            this.managedListId = managedListId;
            return this;
        }

        public Builder updateManagedListDetails(UpdateManagedListDetails updateManagedListDetails) {
            this.updateManagedListDetails = updateManagedListDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateManagedListRequest o) {
            this.managedListId(o.getManagedListId());
            this.updateManagedListDetails(o.getUpdateManagedListDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateManagedListRequest build() {
            UpdateManagedListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateManagedListDetails body) {
            this.updateManagedListDetails(body);
            return this;
        }

        public UpdateManagedListRequest buildWithoutInvocationCallback() {
            UpdateManagedListRequest request = new UpdateManagedListRequest();
            request.managedListId = this.managedListId;
            request.updateManagedListDetails = this.updateManagedListDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

