/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class RequestSummarizedTrendSecurityScoresRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeScoreComputedGreaterThanOrEqualTo;
    private Date timeScoreComputedLessThanOrEqualTo;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeScoreComputedGreaterThanOrEqualTo() {
        return this.timeScoreComputedGreaterThanOrEqualTo;
    }

    public Date getTimeScoreComputedLessThanOrEqualTo() {
        return this.timeScoreComputedLessThanOrEqualTo;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeScoreComputedGreaterThanOrEqualTo(this.timeScoreComputedGreaterThanOrEqualTo).timeScoreComputedLessThanOrEqualTo(this.timeScoreComputedLessThanOrEqualTo).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeScoreComputedGreaterThanOrEqualTo=").append(String.valueOf(this.timeScoreComputedGreaterThanOrEqualTo));
        sb.append(",timeScoreComputedLessThanOrEqualTo=").append(String.valueOf(this.timeScoreComputedLessThanOrEqualTo));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestSummarizedTrendSecurityScoresRequest)) {
            return false;
        }
        RequestSummarizedTrendSecurityScoresRequest other = (RequestSummarizedTrendSecurityScoresRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeScoreComputedGreaterThanOrEqualTo, other.timeScoreComputedGreaterThanOrEqualTo) && Objects.equals(this.timeScoreComputedLessThanOrEqualTo, other.timeScoreComputedLessThanOrEqualTo) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeScoreComputedGreaterThanOrEqualTo == null ? 43 : this.timeScoreComputedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeScoreComputedLessThanOrEqualTo == null ? 43 : this.timeScoreComputedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedTrendSecurityScoresRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date timeScoreComputedGreaterThanOrEqualTo = null;
        private Date timeScoreComputedLessThanOrEqualTo = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeScoreComputedGreaterThanOrEqualTo(Date timeScoreComputedGreaterThanOrEqualTo) {
            this.timeScoreComputedGreaterThanOrEqualTo = timeScoreComputedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeScoreComputedLessThanOrEqualTo(Date timeScoreComputedLessThanOrEqualTo) {
            this.timeScoreComputedLessThanOrEqualTo = timeScoreComputedLessThanOrEqualTo;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedTrendSecurityScoresRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeScoreComputedGreaterThanOrEqualTo(o.getTimeScoreComputedGreaterThanOrEqualTo());
            this.timeScoreComputedLessThanOrEqualTo(o.getTimeScoreComputedLessThanOrEqualTo());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedTrendSecurityScoresRequest build() {
            RequestSummarizedTrendSecurityScoresRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestSummarizedTrendSecurityScoresRequest buildWithoutInvocationCallback() {
            RequestSummarizedTrendSecurityScoresRequest request = new RequestSummarizedTrendSecurityScoresRequest();
            request.compartmentId = this.compartmentId;
            request.timeScoreComputedGreaterThanOrEqualTo = this.timeScoreComputedGreaterThanOrEqualTo;
            request.timeScoreComputedLessThanOrEqualTo = this.timeScoreComputedLessThanOrEqualTo;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

