/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RequestSummarizedTopTrendResourceProfileRiskScoresRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeScoreComputedGreaterThanOrEqualTo;
    private Date timeScoreComputedLessThanOrEqualTo;
    private Boolean compartmentIdInSubtree;
    private SortBy sortBy;
    private Integer count;
    private AccessLevel accessLevel;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeScoreComputedGreaterThanOrEqualTo() {
        return this.timeScoreComputedGreaterThanOrEqualTo;
    }

    public Date getTimeScoreComputedLessThanOrEqualTo() {
        return this.timeScoreComputedLessThanOrEqualTo;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getCount() {
        return this.count;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeScoreComputedGreaterThanOrEqualTo(this.timeScoreComputedGreaterThanOrEqualTo).timeScoreComputedLessThanOrEqualTo(this.timeScoreComputedLessThanOrEqualTo).compartmentIdInSubtree(this.compartmentIdInSubtree).sortBy(this.sortBy).count(this.count).accessLevel(this.accessLevel).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeScoreComputedGreaterThanOrEqualTo=").append(String.valueOf(this.timeScoreComputedGreaterThanOrEqualTo));
        sb.append(",timeScoreComputedLessThanOrEqualTo=").append(String.valueOf(this.timeScoreComputedLessThanOrEqualTo));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",count=").append(String.valueOf(this.count));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestSummarizedTopTrendResourceProfileRiskScoresRequest)) {
            return false;
        }
        RequestSummarizedTopTrendResourceProfileRiskScoresRequest other = (RequestSummarizedTopTrendResourceProfileRiskScoresRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeScoreComputedGreaterThanOrEqualTo, other.timeScoreComputedGreaterThanOrEqualTo) && Objects.equals(this.timeScoreComputedLessThanOrEqualTo, other.timeScoreComputedLessThanOrEqualTo) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.count, other.count) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeScoreComputedGreaterThanOrEqualTo == null ? 43 : this.timeScoreComputedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeScoreComputedLessThanOrEqualTo == null ? 43 : this.timeScoreComputedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedTopTrendResourceProfileRiskScoresRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date timeScoreComputedGreaterThanOrEqualTo = null;
        private Date timeScoreComputedLessThanOrEqualTo = null;
        private Boolean compartmentIdInSubtree = null;
        private SortBy sortBy = null;
        private Integer count = null;
        private AccessLevel accessLevel = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeScoreComputedGreaterThanOrEqualTo(Date timeScoreComputedGreaterThanOrEqualTo) {
            this.timeScoreComputedGreaterThanOrEqualTo = timeScoreComputedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeScoreComputedLessThanOrEqualTo(Date timeScoreComputedLessThanOrEqualTo) {
            this.timeScoreComputedLessThanOrEqualTo = timeScoreComputedLessThanOrEqualTo;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedTopTrendResourceProfileRiskScoresRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeScoreComputedGreaterThanOrEqualTo(o.getTimeScoreComputedGreaterThanOrEqualTo());
            this.timeScoreComputedLessThanOrEqualTo(o.getTimeScoreComputedLessThanOrEqualTo());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.sortBy(o.getSortBy());
            this.count(o.getCount());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedTopTrendResourceProfileRiskScoresRequest build() {
            RequestSummarizedTopTrendResourceProfileRiskScoresRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestSummarizedTopTrendResourceProfileRiskScoresRequest buildWithoutInvocationCallback() {
            RequestSummarizedTopTrendResourceProfileRiskScoresRequest request = new RequestSummarizedTopTrendResourceProfileRiskScoresRequest();
            request.compartmentId = this.compartmentId;
            request.timeScoreComputedGreaterThanOrEqualTo = this.timeScoreComputedGreaterThanOrEqualTo;
            request.timeScoreComputedLessThanOrEqualTo = this.timeScoreComputedLessThanOrEqualTo;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.sortBy = this.sortBy;
            request.count = this.count;
            request.accessLevel = this.accessLevel;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        RiskScore("riskScore"),
        RiskScoreGrowth("riskScoreGrowth"),
        TimeFirstDetected("timeFirstDetected"),
        TimeLastDetected("timeLastDetected");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

