/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListResourceProfilesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeLastDetectedGreaterThanOrEqualTo;
    private Date timeLastDetectedLessThanOrEqualTo;
    private Date timeFirstDetectedGreaterThanOrEqualTo;
    private Date timeFirstDetectedLessThanOrEqualTo;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private List<String> resourceTypes;
    private Double riskScoreGreaterThanOrEqualTo;
    private Double riskScoreLessThanOrEqualTo;
    private List<String> techniques;
    private List<String> tactics;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeLastDetectedGreaterThanOrEqualTo() {
        return this.timeLastDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeLastDetectedLessThanOrEqualTo() {
        return this.timeLastDetectedLessThanOrEqualTo;
    }

    public Date getTimeFirstDetectedGreaterThanOrEqualTo() {
        return this.timeFirstDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeFirstDetectedLessThanOrEqualTo() {
        return this.timeFirstDetectedLessThanOrEqualTo;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public Double getRiskScoreGreaterThanOrEqualTo() {
        return this.riskScoreGreaterThanOrEqualTo;
    }

    public Double getRiskScoreLessThanOrEqualTo() {
        return this.riskScoreLessThanOrEqualTo;
    }

    public List<String> getTechniques() {
        return this.techniques;
    }

    public List<String> getTactics() {
        return this.tactics;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeLastDetectedGreaterThanOrEqualTo(this.timeLastDetectedGreaterThanOrEqualTo).timeLastDetectedLessThanOrEqualTo(this.timeLastDetectedLessThanOrEqualTo).timeFirstDetectedGreaterThanOrEqualTo(this.timeFirstDetectedGreaterThanOrEqualTo).timeFirstDetectedLessThanOrEqualTo(this.timeFirstDetectedLessThanOrEqualTo).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).resourceTypes(this.resourceTypes).riskScoreGreaterThanOrEqualTo(this.riskScoreGreaterThanOrEqualTo).riskScoreLessThanOrEqualTo(this.riskScoreLessThanOrEqualTo).techniques(this.techniques).tactics(this.tactics).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeLastDetectedGreaterThanOrEqualTo=").append(String.valueOf(this.timeLastDetectedGreaterThanOrEqualTo));
        sb.append(",timeLastDetectedLessThanOrEqualTo=").append(String.valueOf(this.timeLastDetectedLessThanOrEqualTo));
        sb.append(",timeFirstDetectedGreaterThanOrEqualTo=").append(String.valueOf(this.timeFirstDetectedGreaterThanOrEqualTo));
        sb.append(",timeFirstDetectedLessThanOrEqualTo=").append(String.valueOf(this.timeFirstDetectedLessThanOrEqualTo));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",resourceTypes=").append(String.valueOf(this.resourceTypes));
        sb.append(",riskScoreGreaterThanOrEqualTo=").append(String.valueOf(this.riskScoreGreaterThanOrEqualTo));
        sb.append(",riskScoreLessThanOrEqualTo=").append(String.valueOf(this.riskScoreLessThanOrEqualTo));
        sb.append(",techniques=").append(String.valueOf(this.techniques));
        sb.append(",tactics=").append(String.valueOf(this.tactics));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListResourceProfilesRequest)) {
            return false;
        }
        ListResourceProfilesRequest other = (ListResourceProfilesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeLastDetectedGreaterThanOrEqualTo, other.timeLastDetectedGreaterThanOrEqualTo) && Objects.equals(this.timeLastDetectedLessThanOrEqualTo, other.timeLastDetectedLessThanOrEqualTo) && Objects.equals(this.timeFirstDetectedGreaterThanOrEqualTo, other.timeFirstDetectedGreaterThanOrEqualTo) && Objects.equals(this.timeFirstDetectedLessThanOrEqualTo, other.timeFirstDetectedLessThanOrEqualTo) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.resourceTypes, other.resourceTypes) && Objects.equals(this.riskScoreGreaterThanOrEqualTo, other.riskScoreGreaterThanOrEqualTo) && Objects.equals(this.riskScoreLessThanOrEqualTo, other.riskScoreLessThanOrEqualTo) && Objects.equals(this.techniques, other.techniques) && Objects.equals(this.tactics, other.tactics) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeLastDetectedGreaterThanOrEqualTo == null ? 43 : this.timeLastDetectedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLastDetectedLessThanOrEqualTo == null ? 43 : this.timeLastDetectedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeFirstDetectedGreaterThanOrEqualTo == null ? 43 : this.timeFirstDetectedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeFirstDetectedLessThanOrEqualTo == null ? 43 : this.timeFirstDetectedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.resourceTypes == null ? 43 : this.resourceTypes.hashCode());
        result = result * 59 + (this.riskScoreGreaterThanOrEqualTo == null ? 43 : this.riskScoreGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.riskScoreLessThanOrEqualTo == null ? 43 : this.riskScoreLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.techniques == null ? 43 : this.techniques.hashCode());
        result = result * 59 + (this.tactics == null ? 43 : this.tactics.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResourceProfilesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date timeLastDetectedGreaterThanOrEqualTo = null;
        private Date timeLastDetectedLessThanOrEqualTo = null;
        private Date timeFirstDetectedGreaterThanOrEqualTo = null;
        private Date timeFirstDetectedLessThanOrEqualTo = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private List<String> resourceTypes = null;
        private Double riskScoreGreaterThanOrEqualTo = null;
        private Double riskScoreLessThanOrEqualTo = null;
        private List<String> techniques = null;
        private List<String> tactics = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeLastDetectedGreaterThanOrEqualTo(Date timeLastDetectedGreaterThanOrEqualTo) {
            this.timeLastDetectedGreaterThanOrEqualTo = timeLastDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLastDetectedLessThanOrEqualTo(Date timeLastDetectedLessThanOrEqualTo) {
            this.timeLastDetectedLessThanOrEqualTo = timeLastDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedGreaterThanOrEqualTo(Date timeFirstDetectedGreaterThanOrEqualTo) {
            this.timeFirstDetectedGreaterThanOrEqualTo = timeFirstDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedLessThanOrEqualTo(Date timeFirstDetectedLessThanOrEqualTo) {
            this.timeFirstDetectedLessThanOrEqualTo = timeFirstDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder resourceTypes(List<String> resourceTypes) {
            this.resourceTypes = resourceTypes;
            return this;
        }

        public Builder resourceTypes(String singularValue) {
            return this.resourceTypes(Arrays.asList(singularValue));
        }

        public Builder riskScoreGreaterThanOrEqualTo(Double riskScoreGreaterThanOrEqualTo) {
            this.riskScoreGreaterThanOrEqualTo = riskScoreGreaterThanOrEqualTo;
            return this;
        }

        public Builder riskScoreLessThanOrEqualTo(Double riskScoreLessThanOrEqualTo) {
            this.riskScoreLessThanOrEqualTo = riskScoreLessThanOrEqualTo;
            return this;
        }

        public Builder techniques(List<String> techniques) {
            this.techniques = techniques;
            return this;
        }

        public Builder techniques(String singularValue) {
            return this.techniques(Arrays.asList(singularValue));
        }

        public Builder tactics(List<String> tactics) {
            this.tactics = tactics;
            return this;
        }

        public Builder tactics(String singularValue) {
            return this.tactics(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResourceProfilesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeLastDetectedGreaterThanOrEqualTo(o.getTimeLastDetectedGreaterThanOrEqualTo());
            this.timeLastDetectedLessThanOrEqualTo(o.getTimeLastDetectedLessThanOrEqualTo());
            this.timeFirstDetectedGreaterThanOrEqualTo(o.getTimeFirstDetectedGreaterThanOrEqualTo());
            this.timeFirstDetectedLessThanOrEqualTo(o.getTimeFirstDetectedLessThanOrEqualTo());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.resourceTypes(o.getResourceTypes());
            this.riskScoreGreaterThanOrEqualTo(o.getRiskScoreGreaterThanOrEqualTo());
            this.riskScoreLessThanOrEqualTo(o.getRiskScoreLessThanOrEqualTo());
            this.techniques(o.getTechniques());
            this.tactics(o.getTactics());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResourceProfilesRequest build() {
            ListResourceProfilesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListResourceProfilesRequest buildWithoutInvocationCallback() {
            ListResourceProfilesRequest request = new ListResourceProfilesRequest();
            request.compartmentId = this.compartmentId;
            request.timeLastDetectedGreaterThanOrEqualTo = this.timeLastDetectedGreaterThanOrEqualTo;
            request.timeLastDetectedLessThanOrEqualTo = this.timeLastDetectedLessThanOrEqualTo;
            request.timeFirstDetectedGreaterThanOrEqualTo = this.timeFirstDetectedGreaterThanOrEqualTo;
            request.timeFirstDetectedLessThanOrEqualTo = this.timeFirstDetectedLessThanOrEqualTo;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.resourceTypes = this.resourceTypes;
            request.riskScoreGreaterThanOrEqualTo = this.riskScoreGreaterThanOrEqualTo;
            request.riskScoreLessThanOrEqualTo = this.riskScoreLessThanOrEqualTo;
            request.techniques = this.techniques;
            request.tactics = this.tactics;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        RiskScore("riskScore"),
        RiskScoreGrowth("riskScoreGrowth"),
        TimeFirstDetected("timeFirstDetected"),
        TimeLastDetected("timeLastDetected"),
        SightingsCount("sightingsCount"),
        DisplayName("displayName"),
        Type("type");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

