/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.DetectorEnum;
import com.oracle.bmc.cloudguard.model.ProblemCategoryEnum;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleDetail;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleState;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListProblemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeLastDetectedGreaterThanOrEqualTo;
    private Date timeLastDetectedLessThanOrEqualTo;
    private Date timeFirstDetectedGreaterThanOrEqualTo;
    private Date timeFirstDetectedLessThanOrEqualTo;
    private ProblemLifecycleDetail lifecycleDetail;
    private ProblemLifecycleState lifecycleState;
    private String region;
    private String riskLevel;
    private String resourceType;
    private String city;
    private String state;
    private String country;
    private String label;
    private List<String> detectorRuleIdList;
    private DetectorEnum detectorType;
    private String targetId;
    private ProblemCategoryEnum problemCategory;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private String resourceId;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeLastDetectedGreaterThanOrEqualTo() {
        return this.timeLastDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeLastDetectedLessThanOrEqualTo() {
        return this.timeLastDetectedLessThanOrEqualTo;
    }

    public Date getTimeFirstDetectedGreaterThanOrEqualTo() {
        return this.timeFirstDetectedGreaterThanOrEqualTo;
    }

    public Date getTimeFirstDetectedLessThanOrEqualTo() {
        return this.timeFirstDetectedLessThanOrEqualTo;
    }

    public ProblemLifecycleDetail getLifecycleDetail() {
        return this.lifecycleDetail;
    }

    public ProblemLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRiskLevel() {
        return this.riskLevel;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getDetectorRuleIdList() {
        return this.detectorRuleIdList;
    }

    public DetectorEnum getDetectorType() {
        return this.detectorType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public ProblemCategoryEnum getProblemCategory() {
        return this.problemCategory;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeLastDetectedGreaterThanOrEqualTo(this.timeLastDetectedGreaterThanOrEqualTo).timeLastDetectedLessThanOrEqualTo(this.timeLastDetectedLessThanOrEqualTo).timeFirstDetectedGreaterThanOrEqualTo(this.timeFirstDetectedGreaterThanOrEqualTo).timeFirstDetectedLessThanOrEqualTo(this.timeFirstDetectedLessThanOrEqualTo).lifecycleDetail(this.lifecycleDetail).lifecycleState(this.lifecycleState).region(this.region).riskLevel(this.riskLevel).resourceType(this.resourceType).city(this.city).state(this.state).country(this.country).label(this.label).detectorRuleIdList(this.detectorRuleIdList).detectorType(this.detectorType).targetId(this.targetId).problemCategory(this.problemCategory).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).resourceId(this.resourceId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeLastDetectedGreaterThanOrEqualTo=").append(String.valueOf(this.timeLastDetectedGreaterThanOrEqualTo));
        sb.append(",timeLastDetectedLessThanOrEqualTo=").append(String.valueOf(this.timeLastDetectedLessThanOrEqualTo));
        sb.append(",timeFirstDetectedGreaterThanOrEqualTo=").append(String.valueOf(this.timeFirstDetectedGreaterThanOrEqualTo));
        sb.append(",timeFirstDetectedLessThanOrEqualTo=").append(String.valueOf(this.timeFirstDetectedLessThanOrEqualTo));
        sb.append(",lifecycleDetail=").append(String.valueOf((Object)this.lifecycleDetail));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",region=").append(String.valueOf(this.region));
        sb.append(",riskLevel=").append(String.valueOf(this.riskLevel));
        sb.append(",resourceType=").append(String.valueOf(this.resourceType));
        sb.append(",city=").append(String.valueOf(this.city));
        sb.append(",state=").append(String.valueOf(this.state));
        sb.append(",country=").append(String.valueOf(this.country));
        sb.append(",label=").append(String.valueOf(this.label));
        sb.append(",detectorRuleIdList=").append(String.valueOf(this.detectorRuleIdList));
        sb.append(",detectorType=").append(String.valueOf((Object)this.detectorType));
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",problemCategory=").append(String.valueOf((Object)this.problemCategory));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProblemsRequest)) {
            return false;
        }
        ListProblemsRequest other = (ListProblemsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeLastDetectedGreaterThanOrEqualTo, other.timeLastDetectedGreaterThanOrEqualTo) && Objects.equals(this.timeLastDetectedLessThanOrEqualTo, other.timeLastDetectedLessThanOrEqualTo) && Objects.equals(this.timeFirstDetectedGreaterThanOrEqualTo, other.timeFirstDetectedGreaterThanOrEqualTo) && Objects.equals(this.timeFirstDetectedLessThanOrEqualTo, other.timeFirstDetectedLessThanOrEqualTo) && Objects.equals((Object)this.lifecycleDetail, (Object)other.lifecycleDetail) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.region, other.region) && Objects.equals(this.riskLevel, other.riskLevel) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.city, other.city) && Objects.equals(this.state, other.state) && Objects.equals(this.country, other.country) && Objects.equals(this.label, other.label) && Objects.equals(this.detectorRuleIdList, other.detectorRuleIdList) && Objects.equals((Object)this.detectorType, (Object)other.detectorType) && Objects.equals(this.targetId, other.targetId) && Objects.equals((Object)this.problemCategory, (Object)other.problemCategory) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeLastDetectedGreaterThanOrEqualTo == null ? 43 : this.timeLastDetectedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLastDetectedLessThanOrEqualTo == null ? 43 : this.timeLastDetectedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeFirstDetectedGreaterThanOrEqualTo == null ? 43 : this.timeFirstDetectedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeFirstDetectedLessThanOrEqualTo == null ? 43 : this.timeFirstDetectedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.lifecycleDetail == null ? 43 : this.lifecycleDetail.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.riskLevel == null ? 43 : this.riskLevel.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.city == null ? 43 : this.city.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.country == null ? 43 : this.country.hashCode());
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.detectorRuleIdList == null ? 43 : this.detectorRuleIdList.hashCode());
        result = result * 59 + (this.detectorType == null ? 43 : this.detectorType.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.problemCategory == null ? 43 : this.problemCategory.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProblemsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date timeLastDetectedGreaterThanOrEqualTo = null;
        private Date timeLastDetectedLessThanOrEqualTo = null;
        private Date timeFirstDetectedGreaterThanOrEqualTo = null;
        private Date timeFirstDetectedLessThanOrEqualTo = null;
        private ProblemLifecycleDetail lifecycleDetail = null;
        private ProblemLifecycleState lifecycleState = null;
        private String region = null;
        private String riskLevel = null;
        private String resourceType = null;
        private String city = null;
        private String state = null;
        private String country = null;
        private String label = null;
        private List<String> detectorRuleIdList = null;
        private DetectorEnum detectorType = null;
        private String targetId = null;
        private ProblemCategoryEnum problemCategory = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private String resourceId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeLastDetectedGreaterThanOrEqualTo(Date timeLastDetectedGreaterThanOrEqualTo) {
            this.timeLastDetectedGreaterThanOrEqualTo = timeLastDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLastDetectedLessThanOrEqualTo(Date timeLastDetectedLessThanOrEqualTo) {
            this.timeLastDetectedLessThanOrEqualTo = timeLastDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedGreaterThanOrEqualTo(Date timeFirstDetectedGreaterThanOrEqualTo) {
            this.timeFirstDetectedGreaterThanOrEqualTo = timeFirstDetectedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeFirstDetectedLessThanOrEqualTo(Date timeFirstDetectedLessThanOrEqualTo) {
            this.timeFirstDetectedLessThanOrEqualTo = timeFirstDetectedLessThanOrEqualTo;
            return this;
        }

        public Builder lifecycleDetail(ProblemLifecycleDetail lifecycleDetail) {
            this.lifecycleDetail = lifecycleDetail;
            return this;
        }

        public Builder lifecycleState(ProblemLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder detectorRuleIdList(List<String> detectorRuleIdList) {
            this.detectorRuleIdList = detectorRuleIdList;
            return this;
        }

        public Builder detectorRuleIdList(String singularValue) {
            return this.detectorRuleIdList(Arrays.asList(singularValue));
        }

        public Builder detectorType(DetectorEnum detectorType) {
            this.detectorType = detectorType;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder problemCategory(ProblemCategoryEnum problemCategory) {
            this.problemCategory = problemCategory;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProblemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeLastDetectedGreaterThanOrEqualTo(o.getTimeLastDetectedGreaterThanOrEqualTo());
            this.timeLastDetectedLessThanOrEqualTo(o.getTimeLastDetectedLessThanOrEqualTo());
            this.timeFirstDetectedGreaterThanOrEqualTo(o.getTimeFirstDetectedGreaterThanOrEqualTo());
            this.timeFirstDetectedLessThanOrEqualTo(o.getTimeFirstDetectedLessThanOrEqualTo());
            this.lifecycleDetail(o.getLifecycleDetail());
            this.lifecycleState(o.getLifecycleState());
            this.region(o.getRegion());
            this.riskLevel(o.getRiskLevel());
            this.resourceType(o.getResourceType());
            this.city(o.getCity());
            this.state(o.getState());
            this.country(o.getCountry());
            this.label(o.getLabel());
            this.detectorRuleIdList(o.getDetectorRuleIdList());
            this.detectorType(o.getDetectorType());
            this.targetId(o.getTargetId());
            this.problemCategory(o.getProblemCategory());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.resourceId(o.getResourceId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProblemsRequest build() {
            ListProblemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListProblemsRequest buildWithoutInvocationCallback() {
            ListProblemsRequest request = new ListProblemsRequest();
            request.compartmentId = this.compartmentId;
            request.timeLastDetectedGreaterThanOrEqualTo = this.timeLastDetectedGreaterThanOrEqualTo;
            request.timeLastDetectedLessThanOrEqualTo = this.timeLastDetectedLessThanOrEqualTo;
            request.timeFirstDetectedGreaterThanOrEqualTo = this.timeFirstDetectedGreaterThanOrEqualTo;
            request.timeFirstDetectedLessThanOrEqualTo = this.timeFirstDetectedLessThanOrEqualTo;
            request.lifecycleDetail = this.lifecycleDetail;
            request.lifecycleState = this.lifecycleState;
            request.region = this.region;
            request.riskLevel = this.riskLevel;
            request.resourceType = this.resourceType;
            request.city = this.city;
            request.state = this.state;
            request.country = this.country;
            request.label = this.label;
            request.detectorRuleIdList = this.detectorRuleIdList;
            request.detectorType = this.detectorType;
            request.targetId = this.targetId;
            request.problemCategory = this.problemCategory;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.resourceId = this.resourceId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        RiskLevel("riskLevel"),
        TimeLastDetected("timeLastDetected"),
        ResourceName("resourceName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

