/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSecurityRecipeRequest
extends BmcRequest<Void> {
    private String securityRecipeId;
    private String opcRequestId;

    public String getSecurityRecipeId() {
        return this.securityRecipeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityRecipeId(this.securityRecipeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityRecipeId=").append(String.valueOf(this.securityRecipeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecurityRecipeRequest)) {
            return false;
        }
        GetSecurityRecipeRequest other = (GetSecurityRecipeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityRecipeId, other.securityRecipeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityRecipeId == null ? 43 : this.securityRecipeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecurityRecipeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityRecipeId = null;
        private String opcRequestId = null;

        public Builder securityRecipeId(String securityRecipeId) {
            this.securityRecipeId = securityRecipeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecurityRecipeRequest o) {
            this.securityRecipeId(o.getSecurityRecipeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecurityRecipeRequest build() {
            GetSecurityRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSecurityRecipeRequest buildWithoutInvocationCallback() {
            GetSecurityRecipeRequest request = new GetSecurityRecipeRequest();
            request.securityRecipeId = this.securityRecipeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

