/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDetectorRuleRequest
extends BmcRequest<Void> {
    private String detectorId;
    private String detectorRuleId;
    private String opcRequestId;

    public String getDetectorId() {
        return this.detectorId;
    }

    public String getDetectorRuleId() {
        return this.detectorRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().detectorId(this.detectorId).detectorRuleId(this.detectorRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",detectorId=").append(String.valueOf(this.detectorId));
        sb.append(",detectorRuleId=").append(String.valueOf(this.detectorRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDetectorRuleRequest)) {
            return false;
        }
        GetDetectorRuleRequest other = (GetDetectorRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.detectorId, other.detectorId) && Objects.equals(this.detectorRuleId, other.detectorRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.detectorId == null ? 43 : this.detectorId.hashCode());
        result = result * 59 + (this.detectorRuleId == null ? 43 : this.detectorRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDetectorRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String detectorId = null;
        private String detectorRuleId = null;
        private String opcRequestId = null;

        public Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public Builder detectorRuleId(String detectorRuleId) {
            this.detectorRuleId = detectorRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDetectorRuleRequest o) {
            this.detectorId(o.getDetectorId());
            this.detectorRuleId(o.getDetectorRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDetectorRuleRequest build() {
            GetDetectorRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDetectorRuleRequest buildWithoutInvocationCallback() {
            GetDetectorRuleRequest request = new GetDetectorRuleRequest();
            request.detectorId = this.detectorId;
            request.detectorRuleId = this.detectorRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

