/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.AttachTargetResponderRecipeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTargetResponderRecipeRequest
extends BmcRequest<AttachTargetResponderRecipeDetails> {
    private String targetId;
    private AttachTargetResponderRecipeDetails attachTargetResponderRecipeDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getTargetId() {
        return this.targetId;
    }

    public AttachTargetResponderRecipeDetails getAttachTargetResponderRecipeDetails() {
        return this.attachTargetResponderRecipeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public AttachTargetResponderRecipeDetails getBody$() {
        return this.attachTargetResponderRecipeDetails;
    }

    public Builder toBuilder() {
        return new Builder().targetId(this.targetId).attachTargetResponderRecipeDetails(this.attachTargetResponderRecipeDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",attachTargetResponderRecipeDetails=").append(String.valueOf((Object)this.attachTargetResponderRecipeDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTargetResponderRecipeRequest)) {
            return false;
        }
        CreateTargetResponderRecipeRequest other = (CreateTargetResponderRecipeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetId, other.targetId) && Objects.equals((Object)this.attachTargetResponderRecipeDetails, (Object)other.attachTargetResponderRecipeDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.attachTargetResponderRecipeDetails == null ? 43 : this.attachTargetResponderRecipeDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTargetResponderRecipeRequest, AttachTargetResponderRecipeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetId = null;
        private AttachTargetResponderRecipeDetails attachTargetResponderRecipeDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder attachTargetResponderRecipeDetails(AttachTargetResponderRecipeDetails attachTargetResponderRecipeDetails) {
            this.attachTargetResponderRecipeDetails = attachTargetResponderRecipeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTargetResponderRecipeRequest o) {
            this.targetId(o.getTargetId());
            this.attachTargetResponderRecipeDetails(o.getAttachTargetResponderRecipeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTargetResponderRecipeRequest build() {
            CreateTargetResponderRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AttachTargetResponderRecipeDetails body) {
            this.attachTargetResponderRecipeDetails(body);
            return this;
        }

        public CreateTargetResponderRecipeRequest buildWithoutInvocationCallback() {
            CreateTargetResponderRecipeRequest request = new CreateTargetResponderRecipeRequest();
            request.targetId = this.targetId;
            request.attachTargetResponderRecipeDetails = this.attachTargetResponderRecipeDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

