/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.AttachTargetDetectorRecipeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTargetDetectorRecipeRequest
extends BmcRequest<AttachTargetDetectorRecipeDetails> {
    private String targetId;
    private AttachTargetDetectorRecipeDetails attachTargetDetectorRecipeDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getTargetId() {
        return this.targetId;
    }

    public AttachTargetDetectorRecipeDetails getAttachTargetDetectorRecipeDetails() {
        return this.attachTargetDetectorRecipeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public AttachTargetDetectorRecipeDetails getBody$() {
        return this.attachTargetDetectorRecipeDetails;
    }

    public Builder toBuilder() {
        return new Builder().targetId(this.targetId).attachTargetDetectorRecipeDetails(this.attachTargetDetectorRecipeDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",attachTargetDetectorRecipeDetails=").append(String.valueOf((Object)this.attachTargetDetectorRecipeDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTargetDetectorRecipeRequest)) {
            return false;
        }
        CreateTargetDetectorRecipeRequest other = (CreateTargetDetectorRecipeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetId, other.targetId) && Objects.equals((Object)this.attachTargetDetectorRecipeDetails, (Object)other.attachTargetDetectorRecipeDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.attachTargetDetectorRecipeDetails == null ? 43 : this.attachTargetDetectorRecipeDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTargetDetectorRecipeRequest, AttachTargetDetectorRecipeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetId = null;
        private AttachTargetDetectorRecipeDetails attachTargetDetectorRecipeDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder attachTargetDetectorRecipeDetails(AttachTargetDetectorRecipeDetails attachTargetDetectorRecipeDetails) {
            this.attachTargetDetectorRecipeDetails = attachTargetDetectorRecipeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTargetDetectorRecipeRequest o) {
            this.targetId(o.getTargetId());
            this.attachTargetDetectorRecipeDetails(o.getAttachTargetDetectorRecipeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTargetDetectorRecipeRequest build() {
            CreateTargetDetectorRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AttachTargetDetectorRecipeDetails body) {
            this.attachTargetDetectorRecipeDetails(body);
            return this;
        }

        public CreateTargetDetectorRecipeRequest buildWithoutInvocationCallback() {
            CreateTargetDetectorRecipeRequest request = new CreateTargetDetectorRecipeRequest();
            request.targetId = this.targetId;
            request.attachTargetDetectorRecipeDetails = this.attachTargetDetectorRecipeDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

