/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.RiskLevel;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceRiskScoreAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tactics")
    private final List<String> tactics;
    @JsonProperty(value="scoreTimestamp")
    private final BigDecimal scoreTimestamp;
    @JsonProperty(value="riskScore")
    private final Double riskScore;
    @JsonProperty(value="riskLevel")
    private final RiskLevel riskLevel;

    @Deprecated
    @ConstructorProperties(value={"tactics", "scoreTimestamp", "riskScore", "riskLevel"})
    public ResourceRiskScoreAggregation(List<String> tactics, BigDecimal scoreTimestamp, Double riskScore, RiskLevel riskLevel) {
        this.tactics = tactics;
        this.scoreTimestamp = scoreTimestamp;
        this.riskScore = riskScore;
        this.riskLevel = riskLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getTactics() {
        return this.tactics;
    }

    public BigDecimal getScoreTimestamp() {
        return this.scoreTimestamp;
    }

    public Double getRiskScore() {
        return this.riskScore;
    }

    public RiskLevel getRiskLevel() {
        return this.riskLevel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceRiskScoreAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("tactics=").append(String.valueOf(this.tactics));
        sb.append(", scoreTimestamp=").append(String.valueOf(this.scoreTimestamp));
        sb.append(", riskScore=").append(String.valueOf(this.riskScore));
        sb.append(", riskLevel=").append(String.valueOf((Object)this.riskLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceRiskScoreAggregation)) {
            return false;
        }
        ResourceRiskScoreAggregation other = (ResourceRiskScoreAggregation)((Object)o);
        return Objects.equals(this.tactics, other.tactics) && Objects.equals(this.scoreTimestamp, other.scoreTimestamp) && Objects.equals(this.riskScore, other.riskScore) && Objects.equals((Object)this.riskLevel, (Object)other.riskLevel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tactics == null ? 43 : this.tactics.hashCode());
        result = result * 59 + (this.scoreTimestamp == null ? 43 : this.scoreTimestamp.hashCode());
        result = result * 59 + (this.riskScore == null ? 43 : this.riskScore.hashCode());
        result = result * 59 + (this.riskLevel == null ? 43 : this.riskLevel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tactics")
        private List<String> tactics;
        @JsonProperty(value="scoreTimestamp")
        private BigDecimal scoreTimestamp;
        @JsonProperty(value="riskScore")
        private Double riskScore;
        @JsonProperty(value="riskLevel")
        private RiskLevel riskLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tactics(List<String> tactics) {
            this.tactics = tactics;
            this.__explicitlySet__.add("tactics");
            return this;
        }

        public Builder scoreTimestamp(BigDecimal scoreTimestamp) {
            this.scoreTimestamp = scoreTimestamp;
            this.__explicitlySet__.add("scoreTimestamp");
            return this;
        }

        public Builder riskScore(Double riskScore) {
            this.riskScore = riskScore;
            this.__explicitlySet__.add("riskScore");
            return this;
        }

        public Builder riskLevel(RiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.__explicitlySet__.add("riskLevel");
            return this;
        }

        public ResourceRiskScoreAggregation build() {
            ResourceRiskScoreAggregation model = new ResourceRiskScoreAggregation(this.tactics, this.scoreTimestamp, this.riskScore, this.riskLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceRiskScoreAggregation model) {
            if (model.wasPropertyExplicitlySet("tactics")) {
                this.tactics(model.getTactics());
            }
            if (model.wasPropertyExplicitlySet("scoreTimestamp")) {
                this.scoreTimestamp(model.getScoreTimestamp());
            }
            if (model.wasPropertyExplicitlySet("riskScore")) {
                this.riskScore(model.getRiskScore());
            }
            if (model.wasPropertyExplicitlySet("riskLevel")) {
                this.riskLevel(model.getRiskLevel());
            }
            return this;
        }
    }
}

