/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.EntityDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProblemEntitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="regions")
    private final List<String> regions;
    @JsonProperty(value="timeFirstDetected")
    private final Date timeFirstDetected;
    @JsonProperty(value="problemId")
    private final String problemId;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;
    @JsonProperty(value="resultUrl")
    private final String resultUrl;
    @JsonProperty(value="entityDetails")
    private final List<EntityDetails> entityDetails;

    @Deprecated
    @ConstructorProperties(value={"regions", "timeFirstDetected", "problemId", "timeLastDetected", "resultUrl", "entityDetails"})
    public ProblemEntitySummary(List<String> regions, Date timeFirstDetected, String problemId, Date timeLastDetected, String resultUrl, List<EntityDetails> entityDetails) {
        this.regions = regions;
        this.timeFirstDetected = timeFirstDetected;
        this.problemId = problemId;
        this.timeLastDetected = timeLastDetected;
        this.resultUrl = resultUrl;
        this.entityDetails = entityDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public Date getTimeFirstDetected() {
        return this.timeFirstDetected;
    }

    public String getProblemId() {
        return this.problemId;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public String getResultUrl() {
        return this.resultUrl;
    }

    public List<EntityDetails> getEntityDetails() {
        return this.entityDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProblemEntitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("regions=").append(String.valueOf(this.regions));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", problemId=").append(String.valueOf(this.problemId));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", resultUrl=").append(String.valueOf(this.resultUrl));
        sb.append(", entityDetails=").append(String.valueOf(this.entityDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProblemEntitySummary)) {
            return false;
        }
        ProblemEntitySummary other = (ProblemEntitySummary)((Object)o);
        return Objects.equals(this.regions, other.regions) && Objects.equals(this.timeFirstDetected, other.timeFirstDetected) && Objects.equals(this.problemId, other.problemId) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && Objects.equals(this.resultUrl, other.resultUrl) && Objects.equals(this.entityDetails, other.entityDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = result * 59 + (this.problemId == null ? 43 : this.problemId.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + (this.resultUrl == null ? 43 : this.resultUrl.hashCode());
        result = result * 59 + (this.entityDetails == null ? 43 : this.entityDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="regions")
        private List<String> regions;
        @JsonProperty(value="timeFirstDetected")
        private Date timeFirstDetected;
        @JsonProperty(value="problemId")
        private String problemId;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonProperty(value="resultUrl")
        private String resultUrl;
        @JsonProperty(value="entityDetails")
        private List<EntityDetails> entityDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder regions(List<String> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public Builder timeFirstDetected(Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            this.__explicitlySet__.add("problemId");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public Builder resultUrl(String resultUrl) {
            this.resultUrl = resultUrl;
            this.__explicitlySet__.add("resultUrl");
            return this;
        }

        public Builder entityDetails(List<EntityDetails> entityDetails) {
            this.entityDetails = entityDetails;
            this.__explicitlySet__.add("entityDetails");
            return this;
        }

        public ProblemEntitySummary build() {
            ProblemEntitySummary model = new ProblemEntitySummary(this.regions, this.timeFirstDetected, this.problemId, this.timeLastDetected, this.resultUrl, this.entityDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProblemEntitySummary model) {
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("problemId")) {
                this.problemId(model.getProblemId());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("resultUrl")) {
                this.resultUrl(model.getResultUrl());
            }
            if (model.wasPropertyExplicitlySet("entityDetails")) {
                this.entityDetails(model.getEntityDetails());
            }
            return this;
        }
    }
}

