/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.ContinuousQueryStartPolicy;
import com.oracle.bmc.cloudguard.model.DataSourceDetails;
import com.oracle.bmc.cloudguard.model.LoggingQueryDetails;
import com.oracle.bmc.cloudguard.model.LoggingQueryOperatorType;
import com.oracle.bmc.cloudguard.model.LoggingQueryType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceFeedProvider")
@JsonFilter(value="explicitlySetFilter")
public final class LoggingQueryDataSourceDetails
extends DataSourceDetails {
    @JsonProperty(value="regions")
    private final List<String> regions;
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="intervalInMinutes")
    private final Integer intervalInMinutes;
    @JsonProperty(value="threshold")
    private final Integer threshold;
    @JsonProperty(value="queryStartTime")
    private final ContinuousQueryStartPolicy queryStartTime;
    @JsonProperty(value="operator")
    private final LoggingQueryOperatorType operator;
    @JsonProperty(value="loggingQueryType")
    private final LoggingQueryType loggingQueryType;
    @JsonProperty(value="additionalEntitiesCount")
    private final Integer additionalEntitiesCount;
    @JsonProperty(value="loggingQueryDetails")
    private final LoggingQueryDetails loggingQueryDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LoggingQueryDataSourceDetails(List<String> regions, String query, Integer intervalInMinutes, Integer threshold, ContinuousQueryStartPolicy queryStartTime, LoggingQueryOperatorType operator, LoggingQueryType loggingQueryType, Integer additionalEntitiesCount, LoggingQueryDetails loggingQueryDetails) {
        this.regions = regions;
        this.query = query;
        this.intervalInMinutes = intervalInMinutes;
        this.threshold = threshold;
        this.queryStartTime = queryStartTime;
        this.operator = operator;
        this.loggingQueryType = loggingQueryType;
        this.additionalEntitiesCount = additionalEntitiesCount;
        this.loggingQueryDetails = loggingQueryDetails;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getIntervalInMinutes() {
        return this.intervalInMinutes;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public ContinuousQueryStartPolicy getQueryStartTime() {
        return this.queryStartTime;
    }

    public LoggingQueryOperatorType getOperator() {
        return this.operator;
    }

    public LoggingQueryType getLoggingQueryType() {
        return this.loggingQueryType;
    }

    public Integer getAdditionalEntitiesCount() {
        return this.additionalEntitiesCount;
    }

    public LoggingQueryDetails getLoggingQueryDetails() {
        return this.loggingQueryDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoggingQueryDataSourceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", regions=").append(String.valueOf(this.regions));
        sb.append(", query=").append(String.valueOf(this.query));
        sb.append(", intervalInMinutes=").append(String.valueOf(this.intervalInMinutes));
        sb.append(", threshold=").append(String.valueOf(this.threshold));
        sb.append(", queryStartTime=").append(String.valueOf((Object)this.queryStartTime));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(", loggingQueryType=").append(String.valueOf((Object)this.loggingQueryType));
        sb.append(", additionalEntitiesCount=").append(String.valueOf(this.additionalEntitiesCount));
        sb.append(", loggingQueryDetails=").append(String.valueOf((Object)this.loggingQueryDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoggingQueryDataSourceDetails)) {
            return false;
        }
        LoggingQueryDataSourceDetails other = (LoggingQueryDataSourceDetails)((Object)o);
        return Objects.equals(this.regions, other.regions) && Objects.equals(this.query, other.query) && Objects.equals(this.intervalInMinutes, other.intervalInMinutes) && Objects.equals(this.threshold, other.threshold) && Objects.equals((Object)this.queryStartTime, (Object)other.queryStartTime) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals((Object)this.loggingQueryType, (Object)other.loggingQueryType) && Objects.equals(this.additionalEntitiesCount, other.additionalEntitiesCount) && Objects.equals((Object)this.loggingQueryDetails, (Object)other.loggingQueryDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.intervalInMinutes == null ? 43 : this.intervalInMinutes.hashCode());
        result = result * 59 + (this.threshold == null ? 43 : this.threshold.hashCode());
        result = result * 59 + (this.queryStartTime == null ? 43 : this.queryStartTime.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.loggingQueryType == null ? 43 : this.loggingQueryType.hashCode());
        result = result * 59 + (this.additionalEntitiesCount == null ? 43 : this.additionalEntitiesCount.hashCode());
        result = result * 59 + (this.loggingQueryDetails == null ? 43 : this.loggingQueryDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="regions")
        private List<String> regions;
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="intervalInMinutes")
        private Integer intervalInMinutes;
        @JsonProperty(value="threshold")
        private Integer threshold;
        @JsonProperty(value="queryStartTime")
        private ContinuousQueryStartPolicy queryStartTime;
        @JsonProperty(value="operator")
        private LoggingQueryOperatorType operator;
        @JsonProperty(value="loggingQueryType")
        private LoggingQueryType loggingQueryType;
        @JsonProperty(value="additionalEntitiesCount")
        private Integer additionalEntitiesCount;
        @JsonProperty(value="loggingQueryDetails")
        private LoggingQueryDetails loggingQueryDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder regions(List<String> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder intervalInMinutes(Integer intervalInMinutes) {
            this.intervalInMinutes = intervalInMinutes;
            this.__explicitlySet__.add("intervalInMinutes");
            return this;
        }

        public Builder threshold(Integer threshold) {
            this.threshold = threshold;
            this.__explicitlySet__.add("threshold");
            return this;
        }

        public Builder queryStartTime(ContinuousQueryStartPolicy queryStartTime) {
            this.queryStartTime = queryStartTime;
            this.__explicitlySet__.add("queryStartTime");
            return this;
        }

        public Builder operator(LoggingQueryOperatorType operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder loggingQueryType(LoggingQueryType loggingQueryType) {
            this.loggingQueryType = loggingQueryType;
            this.__explicitlySet__.add("loggingQueryType");
            return this;
        }

        public Builder additionalEntitiesCount(Integer additionalEntitiesCount) {
            this.additionalEntitiesCount = additionalEntitiesCount;
            this.__explicitlySet__.add("additionalEntitiesCount");
            return this;
        }

        public Builder loggingQueryDetails(LoggingQueryDetails loggingQueryDetails) {
            this.loggingQueryDetails = loggingQueryDetails;
            this.__explicitlySet__.add("loggingQueryDetails");
            return this;
        }

        public LoggingQueryDataSourceDetails build() {
            LoggingQueryDataSourceDetails model = new LoggingQueryDataSourceDetails(this.regions, this.query, this.intervalInMinutes, this.threshold, this.queryStartTime, this.operator, this.loggingQueryType, this.additionalEntitiesCount, this.loggingQueryDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoggingQueryDataSourceDetails model) {
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("intervalInMinutes")) {
                this.intervalInMinutes(model.getIntervalInMinutes());
            }
            if (model.wasPropertyExplicitlySet("threshold")) {
                this.threshold(model.getThreshold());
            }
            if (model.wasPropertyExplicitlySet("queryStartTime")) {
                this.queryStartTime(model.getQueryStartTime());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("loggingQueryType")) {
                this.loggingQueryType(model.getLoggingQueryType());
            }
            if (model.wasPropertyExplicitlySet("additionalEntitiesCount")) {
                this.additionalEntitiesCount(model.getAdditionalEntitiesCount());
            }
            if (model.wasPropertyExplicitlySet("loggingQueryDetails")) {
                this.loggingQueryDetails(model.getLoggingQueryDetails());
            }
            return this;
        }
    }
}

