/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.CandidateResponderRule;
import com.oracle.bmc.cloudguard.model.DetectorDetails;
import com.oracle.bmc.cloudguard.model.DetectorEnum;
import com.oracle.bmc.cloudguard.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DetectorRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="recommendation")
    private final String recommendation;
    @JsonProperty(value="detector")
    private final DetectorEnum detector;
    @JsonProperty(value="serviceType")
    private final String serviceType;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="detectorDetails")
    private final DetectorDetails detectorDetails;
    @JsonProperty(value="managedListTypes")
    private final List<ManagedListTypes> managedListTypes;
    @JsonProperty(value="candidateResponderRules")
    private final List<CandidateResponderRule> candidateResponderRules;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "recommendation", "detector", "serviceType", "resourceType", "detectorDetails", "managedListTypes", "candidateResponderRules", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails"})
    public DetectorRule(String id, String displayName, String description, String recommendation, DetectorEnum detector, String serviceType, String resourceType, DetectorDetails detectorDetails, List<ManagedListTypes> managedListTypes, List<CandidateResponderRule> candidateResponderRules, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.recommendation = recommendation;
        this.detector = detector;
        this.serviceType = serviceType;
        this.resourceType = resourceType;
        this.detectorDetails = detectorDetails;
        this.managedListTypes = managedListTypes;
        this.candidateResponderRules = candidateResponderRules;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public DetectorEnum getDetector() {
        return this.detector;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public DetectorDetails getDetectorDetails() {
        return this.detectorDetails;
    }

    public List<ManagedListTypes> getManagedListTypes() {
        return this.managedListTypes;
    }

    public List<CandidateResponderRule> getCandidateResponderRules() {
        return this.candidateResponderRules;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DetectorRule(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", recommendation=").append(String.valueOf(this.recommendation));
        sb.append(", detector=").append(String.valueOf((Object)this.detector));
        sb.append(", serviceType=").append(String.valueOf(this.serviceType));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", detectorDetails=").append(String.valueOf((Object)this.detectorDetails));
        sb.append(", managedListTypes=").append(String.valueOf(this.managedListTypes));
        sb.append(", candidateResponderRules=").append(String.valueOf(this.candidateResponderRules));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectorRule)) {
            return false;
        }
        DetectorRule other = (DetectorRule)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.recommendation, other.recommendation) && Objects.equals((Object)this.detector, (Object)other.detector) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals((Object)this.detectorDetails, (Object)other.detectorDetails) && Objects.equals(this.managedListTypes, other.managedListTypes) && Objects.equals(this.candidateResponderRules, other.candidateResponderRules) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.recommendation == null ? 43 : this.recommendation.hashCode());
        result = result * 59 + (this.detector == null ? 43 : this.detector.hashCode());
        result = result * 59 + (this.serviceType == null ? 43 : this.serviceType.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.detectorDetails == null ? 43 : this.detectorDetails.hashCode());
        result = result * 59 + (this.managedListTypes == null ? 43 : this.managedListTypes.hashCode());
        result = result * 59 + (this.candidateResponderRules == null ? 43 : this.candidateResponderRules.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ManagedListTypes implements BmcEnum
    {
        CidrBlock("CIDR_BLOCK"),
        Users("USERS"),
        Groups("GROUPS"),
        Ipv4Address("IPV4ADDRESS"),
        Ipv6Address("IPV6ADDRESS"),
        ResourceOcid("RESOURCE_OCID"),
        Region("REGION"),
        Country("COUNTRY"),
        State("STATE"),
        City("CITY"),
        Tags("TAGS"),
        Generic("GENERIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagedListTypes> map;

        private ManagedListTypes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagedListTypes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagedListTypes', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagedListTypes.class);
            map = new HashMap<String, ManagedListTypes>();
            for (ManagedListTypes v : ManagedListTypes.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="recommendation")
        private String recommendation;
        @JsonProperty(value="detector")
        private DetectorEnum detector;
        @JsonProperty(value="serviceType")
        private String serviceType;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="detectorDetails")
        private DetectorDetails detectorDetails;
        @JsonProperty(value="managedListTypes")
        private List<ManagedListTypes> managedListTypes;
        @JsonProperty(value="candidateResponderRules")
        private List<CandidateResponderRule> candidateResponderRules;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            this.__explicitlySet__.add("recommendation");
            return this;
        }

        public Builder detector(DetectorEnum detector) {
            this.detector = detector;
            this.__explicitlySet__.add("detector");
            return this;
        }

        public Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            this.__explicitlySet__.add("serviceType");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder detectorDetails(DetectorDetails detectorDetails) {
            this.detectorDetails = detectorDetails;
            this.__explicitlySet__.add("detectorDetails");
            return this;
        }

        public Builder managedListTypes(List<ManagedListTypes> managedListTypes) {
            this.managedListTypes = managedListTypes;
            this.__explicitlySet__.add("managedListTypes");
            return this;
        }

        public Builder candidateResponderRules(List<CandidateResponderRule> candidateResponderRules) {
            this.candidateResponderRules = candidateResponderRules;
            this.__explicitlySet__.add("candidateResponderRules");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public DetectorRule build() {
            DetectorRule model = new DetectorRule(this.id, this.displayName, this.description, this.recommendation, this.detector, this.serviceType, this.resourceType, this.detectorDetails, this.managedListTypes, this.candidateResponderRules, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DetectorRule model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("recommendation")) {
                this.recommendation(model.getRecommendation());
            }
            if (model.wasPropertyExplicitlySet("detector")) {
                this.detector(model.getDetector());
            }
            if (model.wasPropertyExplicitlySet("serviceType")) {
                this.serviceType(model.getServiceType());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("detectorDetails")) {
                this.detectorDetails(model.getDetectorDetails());
            }
            if (model.wasPropertyExplicitlySet("managedListTypes")) {
                this.managedListTypes(model.getManagedListTypes());
            }
            if (model.wasPropertyExplicitlySet("candidateResponderRules")) {
                this.candidateResponderRules(model.getCandidateResponderRules());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            return this;
        }
    }
}

