/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.ConfigurationListItemType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigValue
extends ExplicitlySetBmcModel {
    @JsonProperty(value="listType")
    private final ConfigurationListItemType listType;
    @JsonProperty(value="managedListType")
    private final String managedListType;
    @JsonProperty(value="value")
    private final String value;

    @Deprecated
    @ConstructorProperties(value={"listType", "managedListType", "value"})
    public ConfigValue(ConfigurationListItemType listType, String managedListType, String value) {
        this.listType = listType;
        this.managedListType = managedListType;
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ConfigurationListItemType getListType() {
        return this.listType;
    }

    public String getManagedListType() {
        return this.managedListType;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigValue(");
        sb.append("super=").append(super.toString());
        sb.append("listType=").append(String.valueOf((Object)this.listType));
        sb.append(", managedListType=").append(String.valueOf(this.managedListType));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigValue)) {
            return false;
        }
        ConfigValue other = (ConfigValue)((Object)o);
        return Objects.equals((Object)this.listType, (Object)other.listType) && Objects.equals(this.managedListType, other.managedListType) && Objects.equals(this.value, other.value) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.listType == null ? 43 : this.listType.hashCode());
        result = result * 59 + (this.managedListType == null ? 43 : this.managedListType.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="listType")
        private ConfigurationListItemType listType;
        @JsonProperty(value="managedListType")
        private String managedListType;
        @JsonProperty(value="value")
        private String value;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder listType(ConfigurationListItemType listType) {
            this.listType = listType;
            this.__explicitlySet__.add("listType");
            return this;
        }

        public Builder managedListType(String managedListType) {
            this.managedListType = managedListType;
            this.__explicitlySet__.add("managedListType");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public ConfigValue build() {
            ConfigValue model = new ConfigValue(this.listType, this.managedListType, this.value);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigValue model) {
            if (model.wasPropertyExplicitlySet("listType")) {
                this.listType(model.getListType());
            }
            if (model.wasPropertyExplicitlySet("managedListType")) {
                this.managedListType(model.getManagedListType());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            return this;
        }
    }
}

