/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.Condition;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class CompositeCondition
extends Condition {
    @JsonProperty(value="leftOperand")
    private final Condition leftOperand;
    @JsonProperty(value="compositeOperator")
    private final CompositeOperator compositeOperator;
    @JsonProperty(value="rightOperand")
    private final Condition rightOperand;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CompositeCondition(Condition leftOperand, CompositeOperator compositeOperator, Condition rightOperand) {
        this.leftOperand = leftOperand;
        this.compositeOperator = compositeOperator;
        this.rightOperand = rightOperand;
    }

    public Condition getLeftOperand() {
        return this.leftOperand;
    }

    public CompositeOperator getCompositeOperator() {
        return this.compositeOperator;
    }

    public Condition getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeCondition(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", leftOperand=").append(String.valueOf((Object)this.leftOperand));
        sb.append(", compositeOperator=").append(String.valueOf((Object)this.compositeOperator));
        sb.append(", rightOperand=").append(String.valueOf((Object)this.rightOperand));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeCondition)) {
            return false;
        }
        CompositeCondition other = (CompositeCondition)((Object)o);
        return Objects.equals((Object)this.leftOperand, (Object)other.leftOperand) && Objects.equals((Object)this.compositeOperator, (Object)other.compositeOperator) && Objects.equals((Object)this.rightOperand, (Object)other.rightOperand) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.leftOperand == null ? 43 : this.leftOperand.hashCode());
        result = result * 59 + (this.compositeOperator == null ? 43 : this.compositeOperator.hashCode());
        result = result * 59 + (this.rightOperand == null ? 43 : this.rightOperand.hashCode());
        return result;
    }

    public static enum CompositeOperator implements BmcEnum
    {
        And("AND"),
        Or("OR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CompositeOperator> map;

        private CompositeOperator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CompositeOperator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CompositeOperator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CompositeOperator.class);
            map = new HashMap<String, CompositeOperator>();
            for (CompositeOperator v : CompositeOperator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="leftOperand")
        private Condition leftOperand;
        @JsonProperty(value="compositeOperator")
        private CompositeOperator compositeOperator;
        @JsonProperty(value="rightOperand")
        private Condition rightOperand;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder leftOperand(Condition leftOperand) {
            this.leftOperand = leftOperand;
            this.__explicitlySet__.add("leftOperand");
            return this;
        }

        public Builder compositeOperator(CompositeOperator compositeOperator) {
            this.compositeOperator = compositeOperator;
            this.__explicitlySet__.add("compositeOperator");
            return this;
        }

        public Builder rightOperand(Condition rightOperand) {
            this.rightOperand = rightOperand;
            this.__explicitlySet__.add("rightOperand");
            return this;
        }

        public CompositeCondition build() {
            CompositeCondition model = new CompositeCondition(this.leftOperand, this.compositeOperator, this.rightOperand);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CompositeCondition model) {
            if (model.wasPropertyExplicitlySet("leftOperand")) {
                this.leftOperand(model.getLeftOperand());
            }
            if (model.wasPropertyExplicitlySet("compositeOperator")) {
                this.compositeOperator(model.getCompositeOperator());
            }
            if (model.wasPropertyExplicitlySet("rightOperand")) {
                this.rightOperand(model.getRightOperand());
            }
            return this;
        }
    }
}

