/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.responses;

import com.oracle.bmc.cloudbridge.model.AssetSource;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetAssetSourceResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private AssetSource assetSource;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AssetSource getAssetSource() {
        return this.assetSource;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "assetSource"})
    private GetAssetSourceResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, AssetSource assetSource) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.assetSource = assetSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",assetSource=").append(String.valueOf((Object)this.assetSource));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAssetSourceResponse)) {
            return false;
        }
        GetAssetSourceResponse other = (GetAssetSourceResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.assetSource, (Object)other.assetSource);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.assetSource == null ? 43 : this.assetSource.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetAssetSourceResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private AssetSource assetSource;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder assetSource(AssetSource assetSource) {
            this.assetSource = assetSource;
            return this;
        }

        public Builder copy(GetAssetSourceResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.assetSource(o.getAssetSource());
            return this;
        }

        public GetAssetSourceResponse build() {
            return new GetAssetSourceResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.assetSource);
        }
    }
}

