/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.CustomerTag;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VmwareVmProperties
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cluster")
    private final String cluster;
    @JsonProperty(value="customerFields")
    private final List<String> customerFields;
    @JsonProperty(value="customerTags")
    private final List<CustomerTag> customerTags;
    @JsonProperty(value="instanceUuid")
    private final String instanceUuid;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="vmwareToolsStatus")
    private final String vmwareToolsStatus;
    @JsonProperty(value="isDisksUuidEnabled")
    private final Boolean isDisksUuidEnabled;
    @JsonProperty(value="isDisksCbtEnabled")
    private final Boolean isDisksCbtEnabled;
    @JsonProperty(value="faultToleranceState")
    private final String faultToleranceState;
    @JsonProperty(value="faultToleranceBandwidth")
    private final Integer faultToleranceBandwidth;
    @JsonProperty(value="faultToleranceSecondaryLatency")
    private final Integer faultToleranceSecondaryLatency;

    @Deprecated
    @ConstructorProperties(value={"cluster", "customerFields", "customerTags", "instanceUuid", "path", "vmwareToolsStatus", "isDisksUuidEnabled", "isDisksCbtEnabled", "faultToleranceState", "faultToleranceBandwidth", "faultToleranceSecondaryLatency"})
    public VmwareVmProperties(String cluster, List<String> customerFields, List<CustomerTag> customerTags, String instanceUuid, String path, String vmwareToolsStatus, Boolean isDisksUuidEnabled, Boolean isDisksCbtEnabled, String faultToleranceState, Integer faultToleranceBandwidth, Integer faultToleranceSecondaryLatency) {
        this.cluster = cluster;
        this.customerFields = customerFields;
        this.customerTags = customerTags;
        this.instanceUuid = instanceUuid;
        this.path = path;
        this.vmwareToolsStatus = vmwareToolsStatus;
        this.isDisksUuidEnabled = isDisksUuidEnabled;
        this.isDisksCbtEnabled = isDisksCbtEnabled;
        this.faultToleranceState = faultToleranceState;
        this.faultToleranceBandwidth = faultToleranceBandwidth;
        this.faultToleranceSecondaryLatency = faultToleranceSecondaryLatency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCluster() {
        return this.cluster;
    }

    public List<String> getCustomerFields() {
        return this.customerFields;
    }

    public List<CustomerTag> getCustomerTags() {
        return this.customerTags;
    }

    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    public String getPath() {
        return this.path;
    }

    public String getVmwareToolsStatus() {
        return this.vmwareToolsStatus;
    }

    public Boolean getIsDisksUuidEnabled() {
        return this.isDisksUuidEnabled;
    }

    public Boolean getIsDisksCbtEnabled() {
        return this.isDisksCbtEnabled;
    }

    public String getFaultToleranceState() {
        return this.faultToleranceState;
    }

    public Integer getFaultToleranceBandwidth() {
        return this.faultToleranceBandwidth;
    }

    public Integer getFaultToleranceSecondaryLatency() {
        return this.faultToleranceSecondaryLatency;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmwareVmProperties(");
        sb.append("super=").append(super.toString());
        sb.append("cluster=").append(String.valueOf(this.cluster));
        sb.append(", customerFields=").append(String.valueOf(this.customerFields));
        sb.append(", customerTags=").append(String.valueOf(this.customerTags));
        sb.append(", instanceUuid=").append(String.valueOf(this.instanceUuid));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", vmwareToolsStatus=").append(String.valueOf(this.vmwareToolsStatus));
        sb.append(", isDisksUuidEnabled=").append(String.valueOf(this.isDisksUuidEnabled));
        sb.append(", isDisksCbtEnabled=").append(String.valueOf(this.isDisksCbtEnabled));
        sb.append(", faultToleranceState=").append(String.valueOf(this.faultToleranceState));
        sb.append(", faultToleranceBandwidth=").append(String.valueOf(this.faultToleranceBandwidth));
        sb.append(", faultToleranceSecondaryLatency=").append(String.valueOf(this.faultToleranceSecondaryLatency));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmwareVmProperties)) {
            return false;
        }
        VmwareVmProperties other = (VmwareVmProperties)((Object)o);
        return Objects.equals(this.cluster, other.cluster) && Objects.equals(this.customerFields, other.customerFields) && Objects.equals(this.customerTags, other.customerTags) && Objects.equals(this.instanceUuid, other.instanceUuid) && Objects.equals(this.path, other.path) && Objects.equals(this.vmwareToolsStatus, other.vmwareToolsStatus) && Objects.equals(this.isDisksUuidEnabled, other.isDisksUuidEnabled) && Objects.equals(this.isDisksCbtEnabled, other.isDisksCbtEnabled) && Objects.equals(this.faultToleranceState, other.faultToleranceState) && Objects.equals(this.faultToleranceBandwidth, other.faultToleranceBandwidth) && Objects.equals(this.faultToleranceSecondaryLatency, other.faultToleranceSecondaryLatency) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cluster == null ? 43 : this.cluster.hashCode());
        result = result * 59 + (this.customerFields == null ? 43 : this.customerFields.hashCode());
        result = result * 59 + (this.customerTags == null ? 43 : this.customerTags.hashCode());
        result = result * 59 + (this.instanceUuid == null ? 43 : this.instanceUuid.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.vmwareToolsStatus == null ? 43 : this.vmwareToolsStatus.hashCode());
        result = result * 59 + (this.isDisksUuidEnabled == null ? 43 : this.isDisksUuidEnabled.hashCode());
        result = result * 59 + (this.isDisksCbtEnabled == null ? 43 : this.isDisksCbtEnabled.hashCode());
        result = result * 59 + (this.faultToleranceState == null ? 43 : this.faultToleranceState.hashCode());
        result = result * 59 + (this.faultToleranceBandwidth == null ? 43 : this.faultToleranceBandwidth.hashCode());
        result = result * 59 + (this.faultToleranceSecondaryLatency == null ? 43 : this.faultToleranceSecondaryLatency.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cluster")
        private String cluster;
        @JsonProperty(value="customerFields")
        private List<String> customerFields;
        @JsonProperty(value="customerTags")
        private List<CustomerTag> customerTags;
        @JsonProperty(value="instanceUuid")
        private String instanceUuid;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="vmwareToolsStatus")
        private String vmwareToolsStatus;
        @JsonProperty(value="isDisksUuidEnabled")
        private Boolean isDisksUuidEnabled;
        @JsonProperty(value="isDisksCbtEnabled")
        private Boolean isDisksCbtEnabled;
        @JsonProperty(value="faultToleranceState")
        private String faultToleranceState;
        @JsonProperty(value="faultToleranceBandwidth")
        private Integer faultToleranceBandwidth;
        @JsonProperty(value="faultToleranceSecondaryLatency")
        private Integer faultToleranceSecondaryLatency;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            this.__explicitlySet__.add("cluster");
            return this;
        }

        public Builder customerFields(List<String> customerFields) {
            this.customerFields = customerFields;
            this.__explicitlySet__.add("customerFields");
            return this;
        }

        public Builder customerTags(List<CustomerTag> customerTags) {
            this.customerTags = customerTags;
            this.__explicitlySet__.add("customerTags");
            return this;
        }

        public Builder instanceUuid(String instanceUuid) {
            this.instanceUuid = instanceUuid;
            this.__explicitlySet__.add("instanceUuid");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder vmwareToolsStatus(String vmwareToolsStatus) {
            this.vmwareToolsStatus = vmwareToolsStatus;
            this.__explicitlySet__.add("vmwareToolsStatus");
            return this;
        }

        public Builder isDisksUuidEnabled(Boolean isDisksUuidEnabled) {
            this.isDisksUuidEnabled = isDisksUuidEnabled;
            this.__explicitlySet__.add("isDisksUuidEnabled");
            return this;
        }

        public Builder isDisksCbtEnabled(Boolean isDisksCbtEnabled) {
            this.isDisksCbtEnabled = isDisksCbtEnabled;
            this.__explicitlySet__.add("isDisksCbtEnabled");
            return this;
        }

        public Builder faultToleranceState(String faultToleranceState) {
            this.faultToleranceState = faultToleranceState;
            this.__explicitlySet__.add("faultToleranceState");
            return this;
        }

        public Builder faultToleranceBandwidth(Integer faultToleranceBandwidth) {
            this.faultToleranceBandwidth = faultToleranceBandwidth;
            this.__explicitlySet__.add("faultToleranceBandwidth");
            return this;
        }

        public Builder faultToleranceSecondaryLatency(Integer faultToleranceSecondaryLatency) {
            this.faultToleranceSecondaryLatency = faultToleranceSecondaryLatency;
            this.__explicitlySet__.add("faultToleranceSecondaryLatency");
            return this;
        }

        public VmwareVmProperties build() {
            VmwareVmProperties model = new VmwareVmProperties(this.cluster, this.customerFields, this.customerTags, this.instanceUuid, this.path, this.vmwareToolsStatus, this.isDisksUuidEnabled, this.isDisksCbtEnabled, this.faultToleranceState, this.faultToleranceBandwidth, this.faultToleranceSecondaryLatency);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmwareVmProperties model) {
            if (model.wasPropertyExplicitlySet("cluster")) {
                this.cluster(model.getCluster());
            }
            if (model.wasPropertyExplicitlySet("customerFields")) {
                this.customerFields(model.getCustomerFields());
            }
            if (model.wasPropertyExplicitlySet("customerTags")) {
                this.customerTags(model.getCustomerTags());
            }
            if (model.wasPropertyExplicitlySet("instanceUuid")) {
                this.instanceUuid(model.getInstanceUuid());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("vmwareToolsStatus")) {
                this.vmwareToolsStatus(model.getVmwareToolsStatus());
            }
            if (model.wasPropertyExplicitlySet("isDisksUuidEnabled")) {
                this.isDisksUuidEnabled(model.getIsDisksUuidEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDisksCbtEnabled")) {
                this.isDisksCbtEnabled(model.getIsDisksCbtEnabled());
            }
            if (model.wasPropertyExplicitlySet("faultToleranceState")) {
                this.faultToleranceState(model.getFaultToleranceState());
            }
            if (model.wasPropertyExplicitlySet("faultToleranceBandwidth")) {
                this.faultToleranceBandwidth(model.getFaultToleranceBandwidth());
            }
            if (model.wasPropertyExplicitlySet("faultToleranceSecondaryLatency")) {
                this.faultToleranceSecondaryLatency(model.getFaultToleranceSecondaryLatency());
            }
            return this;
        }
    }
}

