/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Nic
extends ExplicitlySetBmcModel {
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="switchName")
    private final String switchName;
    @JsonProperty(value="macAddress")
    private final String macAddress;
    @JsonProperty(value="macAddressType")
    private final String macAddressType;
    @JsonProperty(value="networkName")
    private final String networkName;
    @JsonProperty(value="ipAddresses")
    private final List<String> ipAddresses;

    @Deprecated
    @ConstructorProperties(value={"label", "switchName", "macAddress", "macAddressType", "networkName", "ipAddresses"})
    public Nic(String label, String switchName, String macAddress, String macAddressType, String networkName, List<String> ipAddresses) {
        this.label = label;
        this.switchName = switchName;
        this.macAddress = macAddress;
        this.macAddressType = macAddressType;
        this.networkName = networkName;
        this.ipAddresses = ipAddresses;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLabel() {
        return this.label;
    }

    public String getSwitchName() {
        return this.switchName;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getMacAddressType() {
        return this.macAddressType;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Nic(");
        sb.append("super=").append(super.toString());
        sb.append("label=").append(String.valueOf(this.label));
        sb.append(", switchName=").append(String.valueOf(this.switchName));
        sb.append(", macAddress=").append(String.valueOf(this.macAddress));
        sb.append(", macAddressType=").append(String.valueOf(this.macAddressType));
        sb.append(", networkName=").append(String.valueOf(this.networkName));
        sb.append(", ipAddresses=").append(String.valueOf(this.ipAddresses));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Nic)) {
            return false;
        }
        Nic other = (Nic)((Object)o);
        return Objects.equals(this.label, other.label) && Objects.equals(this.switchName, other.switchName) && Objects.equals(this.macAddress, other.macAddress) && Objects.equals(this.macAddressType, other.macAddressType) && Objects.equals(this.networkName, other.networkName) && Objects.equals(this.ipAddresses, other.ipAddresses) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.switchName == null ? 43 : this.switchName.hashCode());
        result = result * 59 + (this.macAddress == null ? 43 : this.macAddress.hashCode());
        result = result * 59 + (this.macAddressType == null ? 43 : this.macAddressType.hashCode());
        result = result * 59 + (this.networkName == null ? 43 : this.networkName.hashCode());
        result = result * 59 + (this.ipAddresses == null ? 43 : this.ipAddresses.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="switchName")
        private String switchName;
        @JsonProperty(value="macAddress")
        private String macAddress;
        @JsonProperty(value="macAddressType")
        private String macAddressType;
        @JsonProperty(value="networkName")
        private String networkName;
        @JsonProperty(value="ipAddresses")
        private List<String> ipAddresses;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder switchName(String switchName) {
            this.switchName = switchName;
            this.__explicitlySet__.add("switchName");
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.__explicitlySet__.add("macAddress");
            return this;
        }

        public Builder macAddressType(String macAddressType) {
            this.macAddressType = macAddressType;
            this.__explicitlySet__.add("macAddressType");
            return this;
        }

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.__explicitlySet__.add("networkName");
            return this;
        }

        public Builder ipAddresses(List<String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            this.__explicitlySet__.add("ipAddresses");
            return this;
        }

        public Nic build() {
            Nic model = new Nic(this.label, this.switchName, this.macAddress, this.macAddressType, this.networkName, this.ipAddresses);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Nic model) {
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("switchName")) {
                this.switchName(model.getSwitchName());
            }
            if (model.wasPropertyExplicitlySet("macAddress")) {
                this.macAddress(model.getMacAddress());
            }
            if (model.wasPropertyExplicitlySet("macAddressType")) {
                this.macAddressType(model.getMacAddressType());
            }
            if (model.wasPropertyExplicitlySet("networkName")) {
                this.networkName(model.getNetworkName());
            }
            if (model.wasPropertyExplicitlySet("ipAddresses")) {
                this.ipAddresses(model.getIpAddresses());
            }
            return this;
        }
    }
}

