/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.Agent;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateAgentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="agentType")
    private final Agent.AgentType agentType;
    @JsonProperty(value="agentVersion")
    private final String agentVersion;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="environmentId")
    private final String environmentId;
    @JsonProperty(value="osVersion")
    private final String osVersion;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "agentType", "agentVersion", "compartmentId", "environmentId", "osVersion", "freeformTags", "definedTags"})
    public CreateAgentDetails(String displayName, Agent.AgentType agentType, String agentVersion, String compartmentId, String environmentId, String osVersion, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.agentType = agentType;
        this.agentVersion = agentVersion;
        this.compartmentId = compartmentId;
        this.environmentId = environmentId;
        this.osVersion = osVersion;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Agent.AgentType getAgentType() {
        return this.agentType;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateAgentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", agentType=").append(String.valueOf((Object)this.agentType));
        sb.append(", agentVersion=").append(String.valueOf(this.agentVersion));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", environmentId=").append(String.valueOf(this.environmentId));
        sb.append(", osVersion=").append(String.valueOf(this.osVersion));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAgentDetails)) {
            return false;
        }
        CreateAgentDetails other = (CreateAgentDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.agentType, (Object)other.agentType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.environmentId, other.environmentId) && Objects.equals(this.osVersion, other.osVersion) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.agentType == null ? 43 : this.agentType.hashCode());
        result = result * 59 + (this.agentVersion == null ? 43 : this.agentVersion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.environmentId == null ? 43 : this.environmentId.hashCode());
        result = result * 59 + (this.osVersion == null ? 43 : this.osVersion.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="agentType")
        private Agent.AgentType agentType;
        @JsonProperty(value="agentVersion")
        private String agentVersion;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="environmentId")
        private String environmentId;
        @JsonProperty(value="osVersion")
        private String osVersion;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder agentType(Agent.AgentType agentType) {
            this.agentType = agentType;
            this.__explicitlySet__.add("agentType");
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            this.__explicitlySet__.add("agentVersion");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            this.__explicitlySet__.add("environmentId");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.__explicitlySet__.add("osVersion");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateAgentDetails build() {
            CreateAgentDetails model = new CreateAgentDetails(this.displayName, this.agentType, this.agentVersion, this.compartmentId, this.environmentId, this.osVersion, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateAgentDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("agentType")) {
                this.agentType(model.getAgentType());
            }
            if (model.wasPropertyExplicitlySet("agentVersion")) {
                this.agentVersion(model.getAgentVersion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("environmentId")) {
                this.environmentId(model.getEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("osVersion")) {
                this.osVersion(model.getOsVersion());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

