/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.AssetSourceConnectionLifecycleState;
import com.oracle.bmc.cloudbridge.model.AssetSourceConnectionType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssetSourceConnection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="connectionType")
    private final AssetSourceConnectionType connectionType;
    @JsonProperty(value="connectorId")
    private final String connectorId;
    @JsonProperty(value="assetSourceKey")
    private final String assetSourceKey;
    @JsonProperty(value="lifecycleState")
    private final AssetSourceConnectionLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;

    @Deprecated
    @ConstructorProperties(value={"connectionType", "connectorId", "assetSourceKey", "lifecycleState", "lifecycleDetails"})
    public AssetSourceConnection(AssetSourceConnectionType connectionType, String connectorId, String assetSourceKey, AssetSourceConnectionLifecycleState lifecycleState, String lifecycleDetails) {
        this.connectionType = connectionType;
        this.connectorId = connectorId;
        this.assetSourceKey = assetSourceKey;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AssetSourceConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getAssetSourceKey() {
        return this.assetSourceKey;
    }

    public AssetSourceConnectionLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssetSourceConnection(");
        sb.append("super=").append(super.toString());
        sb.append("connectionType=").append(String.valueOf((Object)this.connectionType));
        sb.append(", connectorId=").append(String.valueOf(this.connectorId));
        sb.append(", assetSourceKey=").append(String.valueOf(this.assetSourceKey));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssetSourceConnection)) {
            return false;
        }
        AssetSourceConnection other = (AssetSourceConnection)((Object)o);
        return Objects.equals((Object)this.connectionType, (Object)other.connectionType) && Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.assetSourceKey, other.assetSourceKey) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.connectionType == null ? 43 : this.connectionType.hashCode());
        result = result * 59 + (this.connectorId == null ? 43 : this.connectorId.hashCode());
        result = result * 59 + (this.assetSourceKey == null ? 43 : this.assetSourceKey.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionType")
        private AssetSourceConnectionType connectionType;
        @JsonProperty(value="connectorId")
        private String connectorId;
        @JsonProperty(value="assetSourceKey")
        private String assetSourceKey;
        @JsonProperty(value="lifecycleState")
        private AssetSourceConnectionLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionType(AssetSourceConnectionType connectionType) {
            this.connectionType = connectionType;
            this.__explicitlySet__.add("connectionType");
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            this.__explicitlySet__.add("connectorId");
            return this;
        }

        public Builder assetSourceKey(String assetSourceKey) {
            this.assetSourceKey = assetSourceKey;
            this.__explicitlySet__.add("assetSourceKey");
            return this;
        }

        public Builder lifecycleState(AssetSourceConnectionLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public AssetSourceConnection build() {
            AssetSourceConnection model = new AssetSourceConnection(this.connectionType, this.connectorId, this.assetSourceKey, this.lifecycleState, this.lifecycleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssetSourceConnection model) {
            if (model.wasPropertyExplicitlySet("connectionType")) {
                this.connectionType(model.getConnectionType());
            }
            if (model.wasPropertyExplicitlySet("connectorId")) {
                this.connectorId(model.getConnectorId());
            }
            if (model.wasPropertyExplicitlySet("assetSourceKey")) {
                this.assetSourceKey(model.getAssetSourceKey());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            return this;
        }
    }
}

