/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.OcbAgentSvc;
import com.oracle.bmc.cloudbridge.model.AgentDependencySummary;
import com.oracle.bmc.cloudbridge.model.AgentSummary;
import com.oracle.bmc.cloudbridge.model.ApplianceImageSummary;
import com.oracle.bmc.cloudbridge.model.EnvironmentSummary;
import com.oracle.bmc.cloudbridge.requests.ListAgentDependenciesRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentsRequest;
import com.oracle.bmc.cloudbridge.requests.ListApplianceImagesRequest;
import com.oracle.bmc.cloudbridge.requests.ListEnvironmentsRequest;
import com.oracle.bmc.cloudbridge.responses.ListAgentDependenciesResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentsResponse;
import com.oracle.bmc.cloudbridge.responses.ListApplianceImagesResponse;
import com.oracle.bmc.cloudbridge.responses.ListEnvironmentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OcbAgentSvcPaginators {
    private final OcbAgentSvc client;

    public OcbAgentSvcPaginators(OcbAgentSvc client) {
        this.client = client;
    }

    public Iterable<ListAgentDependenciesResponse> listAgentDependenciesResponseIterator(final ListAgentDependenciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgentDependenciesRequest.Builder>(){

            @Override
            public ListAgentDependenciesRequest.Builder get() {
                return ListAgentDependenciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentDependenciesResponse, String>(){

            @Override
            public String apply(ListAgentDependenciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentDependenciesRequest.Builder>, ListAgentDependenciesRequest>(){

            @Override
            public ListAgentDependenciesRequest apply(RequestBuilderAndToken<ListAgentDependenciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentDependenciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentDependenciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentDependenciesRequest, ListAgentDependenciesResponse>(){

            @Override
            public ListAgentDependenciesResponse apply(ListAgentDependenciesRequest request) {
                return OcbAgentSvcPaginators.this.client.listAgentDependencies(request);
            }
        });
    }

    public Iterable<AgentDependencySummary> listAgentDependenciesRecordIterator(final ListAgentDependenciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgentDependenciesRequest.Builder>(){

            @Override
            public ListAgentDependenciesRequest.Builder get() {
                return ListAgentDependenciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentDependenciesResponse, String>(){

            @Override
            public String apply(ListAgentDependenciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentDependenciesRequest.Builder>, ListAgentDependenciesRequest>(){

            @Override
            public ListAgentDependenciesRequest apply(RequestBuilderAndToken<ListAgentDependenciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentDependenciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentDependenciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentDependenciesRequest, ListAgentDependenciesResponse>(){

            @Override
            public ListAgentDependenciesResponse apply(ListAgentDependenciesRequest request) {
                return OcbAgentSvcPaginators.this.client.listAgentDependencies(request);
            }
        }, (Function)new Function<ListAgentDependenciesResponse, List<AgentDependencySummary>>(){

            @Override
            public List<AgentDependencySummary> apply(ListAgentDependenciesResponse response) {
                return response.getAgentDependencyCollection().getItems();
            }
        });
    }

    public Iterable<ListAgentsResponse> listAgentsResponseIterator(final ListAgentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgentsRequest.Builder>(){

            @Override
            public ListAgentsRequest.Builder get() {
                return ListAgentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentsResponse, String>(){

            @Override
            public String apply(ListAgentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentsRequest.Builder>, ListAgentsRequest>(){

            @Override
            public ListAgentsRequest apply(RequestBuilderAndToken<ListAgentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentsRequest, ListAgentsResponse>(){

            @Override
            public ListAgentsResponse apply(ListAgentsRequest request) {
                return OcbAgentSvcPaginators.this.client.listAgents(request);
            }
        });
    }

    public Iterable<AgentSummary> listAgentsRecordIterator(final ListAgentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgentsRequest.Builder>(){

            @Override
            public ListAgentsRequest.Builder get() {
                return ListAgentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentsResponse, String>(){

            @Override
            public String apply(ListAgentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentsRequest.Builder>, ListAgentsRequest>(){

            @Override
            public ListAgentsRequest apply(RequestBuilderAndToken<ListAgentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentsRequest, ListAgentsResponse>(){

            @Override
            public ListAgentsResponse apply(ListAgentsRequest request) {
                return OcbAgentSvcPaginators.this.client.listAgents(request);
            }
        }, (Function)new Function<ListAgentsResponse, List<AgentSummary>>(){

            @Override
            public List<AgentSummary> apply(ListAgentsResponse response) {
                return response.getAgentCollection().getItems();
            }
        });
    }

    public Iterable<ListApplianceImagesResponse> listApplianceImagesResponseIterator(final ListApplianceImagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplianceImagesRequest.Builder>(){

            @Override
            public ListApplianceImagesRequest.Builder get() {
                return ListApplianceImagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplianceImagesResponse, String>(){

            @Override
            public String apply(ListApplianceImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplianceImagesRequest.Builder>, ListApplianceImagesRequest>(){

            @Override
            public ListApplianceImagesRequest apply(RequestBuilderAndToken<ListApplianceImagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplianceImagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplianceImagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplianceImagesRequest, ListApplianceImagesResponse>(){

            @Override
            public ListApplianceImagesResponse apply(ListApplianceImagesRequest request) {
                return OcbAgentSvcPaginators.this.client.listApplianceImages(request);
            }
        });
    }

    public Iterable<ApplianceImageSummary> listApplianceImagesRecordIterator(final ListApplianceImagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplianceImagesRequest.Builder>(){

            @Override
            public ListApplianceImagesRequest.Builder get() {
                return ListApplianceImagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplianceImagesResponse, String>(){

            @Override
            public String apply(ListApplianceImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplianceImagesRequest.Builder>, ListApplianceImagesRequest>(){

            @Override
            public ListApplianceImagesRequest apply(RequestBuilderAndToken<ListApplianceImagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplianceImagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplianceImagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplianceImagesRequest, ListApplianceImagesResponse>(){

            @Override
            public ListApplianceImagesResponse apply(ListApplianceImagesRequest request) {
                return OcbAgentSvcPaginators.this.client.listApplianceImages(request);
            }
        }, (Function)new Function<ListApplianceImagesResponse, List<ApplianceImageSummary>>(){

            @Override
            public List<ApplianceImageSummary> apply(ListApplianceImagesResponse response) {
                return response.getApplianceImageCollection().getItems();
            }
        });
    }

    public Iterable<ListEnvironmentsResponse> listEnvironmentsResponseIterator(final ListEnvironmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEnvironmentsRequest.Builder>(){

            @Override
            public ListEnvironmentsRequest.Builder get() {
                return ListEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnvironmentsResponse, String>(){

            @Override
            public String apply(ListEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnvironmentsRequest.Builder>, ListEnvironmentsRequest>(){

            @Override
            public ListEnvironmentsRequest apply(RequestBuilderAndToken<ListEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEnvironmentsRequest, ListEnvironmentsResponse>(){

            @Override
            public ListEnvironmentsResponse apply(ListEnvironmentsRequest request) {
                return OcbAgentSvcPaginators.this.client.listEnvironments(request);
            }
        });
    }

    public Iterable<EnvironmentSummary> listEnvironmentsRecordIterator(final ListEnvironmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEnvironmentsRequest.Builder>(){

            @Override
            public ListEnvironmentsRequest.Builder get() {
                return ListEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEnvironmentsResponse, String>(){

            @Override
            public String apply(ListEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEnvironmentsRequest.Builder>, ListEnvironmentsRequest>(){

            @Override
            public ListEnvironmentsRequest apply(RequestBuilderAndToken<ListEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEnvironmentsRequest, ListEnvironmentsResponse>(){

            @Override
            public ListEnvironmentsResponse apply(ListEnvironmentsRequest request) {
                return OcbAgentSvcPaginators.this.client.listEnvironments(request);
            }
        }, (Function)new Function<ListEnvironmentsResponse, List<EnvironmentSummary>>(){

            @Override
            public List<EnvironmentSummary> apply(ListEnvironmentsResponse response) {
                return response.getEnvironmentCollection().getItems();
            }
        });
    }
}

