/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.Inventory;
import com.oracle.bmc.cloudbridge.model.AssetSummary;
import com.oracle.bmc.cloudbridge.model.HistoricalMetricSummary;
import com.oracle.bmc.cloudbridge.model.InventorySummary;
import com.oracle.bmc.cloudbridge.requests.ListAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ListHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.ListInventoriesRequest;
import com.oracle.bmc.cloudbridge.responses.ListAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ListHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.ListInventoriesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class InventoryPaginators {
    private final Inventory client;

    public InventoryPaginators(Inventory client) {
        this.client = client;
    }

    public Iterable<ListAssetsResponse> listAssetsResponseIterator(final ListAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAssetsRequest.Builder>(){

            @Override
            public ListAssetsRequest.Builder get() {
                return ListAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssetsResponse, String>(){

            @Override
            public String apply(ListAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssetsRequest.Builder>, ListAssetsRequest>(){

            @Override
            public ListAssetsRequest apply(RequestBuilderAndToken<ListAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssetsRequest, ListAssetsResponse>(){

            @Override
            public ListAssetsResponse apply(ListAssetsRequest request) {
                return InventoryPaginators.this.client.listAssets(request);
            }
        });
    }

    public Iterable<AssetSummary> listAssetsRecordIterator(final ListAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAssetsRequest.Builder>(){

            @Override
            public ListAssetsRequest.Builder get() {
                return ListAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssetsResponse, String>(){

            @Override
            public String apply(ListAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssetsRequest.Builder>, ListAssetsRequest>(){

            @Override
            public ListAssetsRequest apply(RequestBuilderAndToken<ListAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssetsRequest, ListAssetsResponse>(){

            @Override
            public ListAssetsResponse apply(ListAssetsRequest request) {
                return InventoryPaginators.this.client.listAssets(request);
            }
        }, (Function)new Function<ListAssetsResponse, List<AssetSummary>>(){

            @Override
            public List<AssetSummary> apply(ListAssetsResponse response) {
                return response.getAssetCollection().getItems();
            }
        });
    }

    public Iterable<ListHistoricalMetricsResponse> listHistoricalMetricsResponseIterator(final ListHistoricalMetricsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHistoricalMetricsRequest.Builder>(){

            @Override
            public ListHistoricalMetricsRequest.Builder get() {
                return ListHistoricalMetricsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHistoricalMetricsResponse, String>(){

            @Override
            public String apply(ListHistoricalMetricsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHistoricalMetricsRequest.Builder>, ListHistoricalMetricsRequest>(){

            @Override
            public ListHistoricalMetricsRequest apply(RequestBuilderAndToken<ListHistoricalMetricsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHistoricalMetricsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHistoricalMetricsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHistoricalMetricsRequest, ListHistoricalMetricsResponse>(){

            @Override
            public ListHistoricalMetricsResponse apply(ListHistoricalMetricsRequest request) {
                return InventoryPaginators.this.client.listHistoricalMetrics(request);
            }
        });
    }

    public Iterable<HistoricalMetricSummary> listHistoricalMetricsRecordIterator(final ListHistoricalMetricsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHistoricalMetricsRequest.Builder>(){

            @Override
            public ListHistoricalMetricsRequest.Builder get() {
                return ListHistoricalMetricsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHistoricalMetricsResponse, String>(){

            @Override
            public String apply(ListHistoricalMetricsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHistoricalMetricsRequest.Builder>, ListHistoricalMetricsRequest>(){

            @Override
            public ListHistoricalMetricsRequest apply(RequestBuilderAndToken<ListHistoricalMetricsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHistoricalMetricsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHistoricalMetricsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHistoricalMetricsRequest, ListHistoricalMetricsResponse>(){

            @Override
            public ListHistoricalMetricsResponse apply(ListHistoricalMetricsRequest request) {
                return InventoryPaginators.this.client.listHistoricalMetrics(request);
            }
        }, (Function)new Function<ListHistoricalMetricsResponse, List<HistoricalMetricSummary>>(){

            @Override
            public List<HistoricalMetricSummary> apply(ListHistoricalMetricsResponse response) {
                return response.getHistoricalMetricCollection().getItems();
            }
        });
    }

    public Iterable<ListInventoriesResponse> listInventoriesResponseIterator(final ListInventoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInventoriesRequest.Builder>(){

            @Override
            public ListInventoriesRequest.Builder get() {
                return ListInventoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInventoriesResponse, String>(){

            @Override
            public String apply(ListInventoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInventoriesRequest.Builder>, ListInventoriesRequest>(){

            @Override
            public ListInventoriesRequest apply(RequestBuilderAndToken<ListInventoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInventoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInventoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInventoriesRequest, ListInventoriesResponse>(){

            @Override
            public ListInventoriesResponse apply(ListInventoriesRequest request) {
                return InventoryPaginators.this.client.listInventories(request);
            }
        });
    }

    public Iterable<InventorySummary> listInventoriesRecordIterator(final ListInventoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInventoriesRequest.Builder>(){

            @Override
            public ListInventoriesRequest.Builder get() {
                return ListInventoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInventoriesResponse, String>(){

            @Override
            public String apply(ListInventoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInventoriesRequest.Builder>, ListInventoriesRequest>(){

            @Override
            public ListInventoriesRequest apply(RequestBuilderAndToken<ListInventoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInventoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInventoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInventoriesRequest, ListInventoriesResponse>(){

            @Override
            public ListInventoriesResponse apply(ListInventoriesRequest request) {
                return InventoryPaginators.this.client.listInventories(request);
            }
        }, (Function)new Function<ListInventoriesResponse, List<InventorySummary>>(){

            @Override
            public List<InventorySummary> apply(ListInventoriesResponse response) {
                return response.getInventoryCollection().getItems();
            }
        });
    }
}

