/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.InventoryAsyncClient;
import com.oracle.bmc.cloudbridge.InventoryPaginators;
import com.oracle.bmc.cloudbridge.InventoryWaiters;
import com.oracle.bmc.cloudbridge.model.Asset;
import com.oracle.bmc.cloudbridge.model.AssetAggregationCollection;
import com.oracle.bmc.cloudbridge.model.AssetCollection;
import com.oracle.bmc.cloudbridge.model.HistoricalMetricCollection;
import com.oracle.bmc.cloudbridge.model.Inventory;
import com.oracle.bmc.cloudbridge.model.InventoryCollection;
import com.oracle.bmc.cloudbridge.requests.AnalyzeAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetTagsRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.CreateInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetRequest;
import com.oracle.bmc.cloudbridge.requests.GetInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ImportInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ListHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.ListInventoriesRequest;
import com.oracle.bmc.cloudbridge.requests.SubmitHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateInventoryRequest;
import com.oracle.bmc.cloudbridge.responses.AnalyzeAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetTagsResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.CreateInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetResponse;
import com.oracle.bmc.cloudbridge.responses.GetInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ImportInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ListHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.ListInventoriesResponse;
import com.oracle.bmc.cloudbridge.responses.SubmitHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateInventoryResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryClient
extends BaseSyncClient
implements com.oracle.bmc.cloudbridge.Inventory {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INVENTORY").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudbridge.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(InventoryAsyncClient.class);
    private final InventoryWaiters waiters;
    private final InventoryPaginators paginators;

    private InventoryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Inventory-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new InventoryWaiters(executorService, this);
        this.paginators = new InventoryPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AnalyzeAssetsResponse analyzeAssets(AnalyzeAssetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAggregationProperties(), "aggregationProperties is required");
        return (AnalyzeAssetsResponse)this.clientCall(request, AnalyzeAssetsResponse::builder).logger(LOG, "analyzeAssets").serviceDetails("Inventory", "AnalyzeAssets", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetAggregation/AnalyzeAssets").method(Method.GET).requestBuilder(AnalyzeAssetsRequest::builder).basePath("/20220509").appendPathParam("assetAnalytics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("sourceKey", (Object)request.getSourceKey()).appendQueryParam("externalAssetKey", (Object)request.getExternalAssetKey()).appendEnumQueryParam("assetType", (BmcEnum)request.getAssetType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("aggregationProperties", request.getAggregationProperties(), CollectionFormatType.Multi).appendListQueryParam("groupBy", request.getGroupBy(), CollectionFormatType.Multi).appendQueryParam("inventoryId", (Object)request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetAggregationCollection.class, AnalyzeAssetsResponse.Builder::assetAggregationCollection).handleResponseHeaderString("opc-request-id", AnalyzeAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", AnalyzeAssetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeAssetCompartmentResponse changeAssetCompartment(ChangeAssetCompartmentRequest request) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAssetCompartmentDetails(), "changeAssetCompartmentDetails is required");
        return (ChangeAssetCompartmentResponse)this.clientCall(request, ChangeAssetCompartmentResponse::builder).logger(LOG, "changeAssetCompartment").serviceDetails("Inventory", "ChangeAssetCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/ChangeAssetCompartment").method(Method.POST).requestBuilder(ChangeAssetCompartmentRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAssetCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeAssetTagsResponse changeAssetTags(ChangeAssetTagsRequest request) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAssetTagsDetails(), "changeAssetTagsDetails is required");
        return (ChangeAssetTagsResponse)this.clientCall(request, ChangeAssetTagsResponse::builder).logger(LOG, "changeAssetTags").serviceDetails("Inventory", "ChangeAssetTags", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/ChangeAssetTags").method(Method.POST).requestBuilder(ChangeAssetTagsRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("actions").appendPathParam("changeTags").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Asset.class, ChangeAssetTagsResponse.Builder::asset).handleResponseHeaderString("etag", ChangeAssetTagsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeAssetTagsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateAssetResponse createAsset(CreateAssetRequest request) {
        Objects.requireNonNull(request.getCreateAssetDetails(), "createAssetDetails is required");
        return (CreateAssetResponse)this.clientCall(request, CreateAssetResponse::builder).logger(LOG, "createAsset").serviceDetails("Inventory", "CreateAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/CreateAsset").method(Method.POST).requestBuilder(CreateAssetRequest::builder).basePath("/20220509").appendPathParam("assets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Asset.class, CreateAssetResponse.Builder::asset).handleResponseHeaderString("etag", CreateAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateInventoryResponse createInventory(CreateInventoryRequest request) {
        Objects.requireNonNull(request.getCreateInventoryDetails(), "createInventoryDetails is required");
        return (CreateInventoryResponse)this.clientCall(request, CreateInventoryResponse::builder).logger(LOG, "createInventory").serviceDetails("Inventory", "CreateInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/CreateInventory").method(Method.POST).requestBuilder(CreateInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateInventoryResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteAssetResponse deleteAsset(DeleteAssetRequest request) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return (DeleteAssetResponse)this.clientCall(request, DeleteAssetResponse::builder).logger(LOG, "deleteAsset").serviceDetails("Inventory", "DeleteAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/DeleteAsset").method(Method.DELETE).requestBuilder(DeleteAssetRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteInventoryResponse deleteInventory(DeleteInventoryRequest request) {
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        return (DeleteInventoryResponse)this.clientCall(request, DeleteInventoryResponse::builder).logger(LOG, "deleteInventory").serviceDetails("Inventory", "DeleteInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/DeleteInventory").method(Method.DELETE).requestBuilder(DeleteInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteInventoryResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAssetResponse getAsset(GetAssetRequest request) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return (GetAssetResponse)this.clientCall(request, GetAssetResponse::builder).logger(LOG, "getAsset").serviceDetails("Inventory", "GetAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/GetAsset").method(Method.GET).requestBuilder(GetAssetRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Asset.class, GetAssetResponse.Builder::asset).handleResponseHeaderString("etag", GetAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetInventoryResponse getInventory(GetInventoryRequest request) {
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        return (GetInventoryResponse)this.clientCall(request, GetInventoryResponse::builder).logger(LOG, "getInventory").serviceDetails("Inventory", "GetInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/GetInventory").method(Method.GET).requestBuilder(GetInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Inventory.class, GetInventoryResponse.Builder::inventory).handleResponseHeaderString("etag", GetInventoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GetInventoryResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ImportInventoryResponse importInventory(ImportInventoryRequest request) {
        Objects.requireNonNull(request.getImportInventoryDetails(), "importInventoryDetails is required");
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        return (ImportInventoryResponse)this.clientCall(request, ImportInventoryResponse::builder).logger(LOG, "importInventory").serviceDetails("Inventory", "ImportInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/ImportInventory").method(Method.POST).requestBuilder(ImportInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).appendPathParam("actions").appendPathParam("import").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ImportInventoryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ImportInventoryResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAssetsResponse listAssets(ListAssetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAssetsResponse)this.clientCall(request, ListAssetsResponse::builder).logger(LOG, "listAssets").serviceDetails("Inventory", "ListAssets", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetCollection/ListAssets").method(Method.GET).requestBuilder(ListAssetsRequest::builder).basePath("/20220509").appendPathParam("assets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("sourceKey", (Object)request.getSourceKey()).appendQueryParam("externalAssetKey", (Object)request.getExternalAssetKey()).appendEnumQueryParam("assetType", (BmcEnum)request.getAssetType()).appendQueryParam("assetId", (Object)request.getAssetId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("inventoryId", (Object)request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetCollection.class, ListAssetsResponse.Builder::assetCollection).handleResponseHeaderString("opc-request-id", ListAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListHistoricalMetricsResponse listHistoricalMetrics(ListHistoricalMetricsRequest request) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return (ListHistoricalMetricsResponse)this.clientCall(request, ListHistoricalMetricsResponse::builder).logger(LOG, "listHistoricalMetrics").serviceDetails("Inventory", "ListHistoricalMetrics", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/HistoricalMetric/ListHistoricalMetrics").method(Method.GET).requestBuilder(ListHistoricalMetricsRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("historicalMetrics").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HistoricalMetricCollection.class, ListHistoricalMetricsResponse.Builder::historicalMetricCollection).handleResponseHeaderString("opc-request-id", ListHistoricalMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHistoricalMetricsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListInventoriesResponse listInventories(ListInventoriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListInventoriesResponse)this.clientCall(request, ListInventoriesResponse::builder).logger(LOG, "listInventories").serviceDetails("Inventory", "ListInventories", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/ListInventories").method(Method.GET).requestBuilder(ListInventoriesRequest::builder).basePath("/20220509").appendPathParam("inventories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InventoryCollection.class, ListInventoriesResponse.Builder::inventoryCollection).handleResponseHeaderString("opc-request-id", ListInventoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInventoriesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SubmitHistoricalMetricsResponse submitHistoricalMetrics(SubmitHistoricalMetricsRequest request) {
        Objects.requireNonNull(request.getSubmitHistoricalMetricsDetails(), "submitHistoricalMetricsDetails is required");
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        return (SubmitHistoricalMetricsResponse)this.clientCall(request, SubmitHistoricalMetricsResponse::builder).logger(LOG, "submitHistoricalMetrics").serviceDetails("Inventory", "SubmitHistoricalMetrics", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/HistoricalMetric/SubmitHistoricalMetrics").method(Method.POST).requestBuilder(SubmitHistoricalMetricsRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).appendPathParam("actions").appendPathParam("submitHistoricalMetrics").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(HistoricalMetricCollection.class, SubmitHistoricalMetricsResponse.Builder::historicalMetricCollection).handleResponseHeaderString("etag", SubmitHistoricalMetricsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SubmitHistoricalMetricsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateAssetResponse updateAsset(UpdateAssetRequest request) {
        Validate.notBlank((String)request.getAssetId(), (String)"assetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAssetDetails(), "updateAssetDetails is required");
        return (UpdateAssetResponse)this.clientCall(request, UpdateAssetResponse::builder).logger(LOG, "updateAsset").serviceDetails("Inventory", "UpdateAsset", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Asset/UpdateAsset").method(Method.PUT).requestBuilder(UpdateAssetRequest::builder).basePath("/20220509").appendPathParam("assets").appendPathParam(request.getAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Asset.class, UpdateAssetResponse.Builder::asset).handleResponseHeaderString("etag", UpdateAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateInventoryResponse updateInventory(UpdateInventoryRequest request) {
        Validate.notBlank((String)request.getInventoryId(), (String)"inventoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInventoryDetails(), "updateInventoryDetails is required");
        return (UpdateInventoryResponse)this.clientCall(request, UpdateInventoryResponse::builder).logger(LOG, "updateInventory").serviceDetails("Inventory", "UpdateInventory", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Inventory/UpdateInventory").method(Method.PUT).requestBuilder(UpdateInventoryRequest::builder).basePath("/20220509").appendPathParam("inventories").appendPathParam(request.getInventoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Inventory.class, UpdateInventoryResponse.Builder::inventory).handleResponseHeaderString("etag", UpdateInventoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInventoryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public InventoryWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public InventoryPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public InventoryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)InventoryClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(InventoryClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)InventoryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)InventoryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)InventoryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)InventoryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)InventoryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public InventoryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)InventoryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, InventoryClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public InventoryClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new InventoryClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

