/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateUserRequest
extends BmcRequest<Void> {
    private String csi;
    private String ocid;
    private String opcRequestId;
    private String problemType;
    private String homeregion;

    public String getCsi() {
        return this.csi;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public Builder toBuilder() {
        return new Builder().csi(this.csi).ocid(this.ocid).opcRequestId(this.opcRequestId).problemType(this.problemType).homeregion(this.homeregion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",problemType=").append(String.valueOf(this.problemType));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateUserRequest)) {
            return false;
        }
        ValidateUserRequest other = (ValidateUserRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.csi, other.csi) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.problemType, other.problemType) && Objects.equals(this.homeregion, other.homeregion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateUserRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String csi = null;
        private String ocid = null;
        private String opcRequestId = null;
        private String problemType = null;
        private String homeregion = null;

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateUserRequest o) {
            this.csi(o.getCsi());
            this.ocid(o.getOcid());
            this.opcRequestId(o.getOpcRequestId());
            this.problemType(o.getProblemType());
            this.homeregion(o.getHomeregion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateUserRequest build() {
            ValidateUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ValidateUserRequest buildWithoutInvocationCallback() {
            ValidateUserRequest request = new ValidateUserRequest();
            request.csi = this.csi;
            request.ocid = this.ocid;
            request.opcRequestId = this.opcRequestId;
            request.problemType = this.problemType;
            request.homeregion = this.homeregion;
            return request;
        }
    }
}

