/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.ContactList;
import com.oracle.bmc.cims.model.IncidentResourceType;
import com.oracle.bmc.cims.model.ProblemType;
import com.oracle.bmc.cims.model.TenancyInformation;
import com.oracle.bmc.cims.model.Ticket;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IncidentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="contactList")
    private final ContactList contactList;
    @JsonProperty(value="tenancyInformation")
    private final TenancyInformation tenancyInformation;
    @JsonProperty(value="ticket")
    private final Ticket ticket;
    @JsonProperty(value="incidentType")
    private final IncidentResourceType incidentType;
    @JsonProperty(value="problemType")
    private final ProblemType problemType;

    @Deprecated
    @ConstructorProperties(value={"key", "compartmentId", "contactList", "tenancyInformation", "ticket", "incidentType", "problemType"})
    public IncidentSummary(String key, String compartmentId, ContactList contactList, TenancyInformation tenancyInformation, Ticket ticket, IncidentResourceType incidentType, ProblemType problemType) {
        this.key = key;
        this.compartmentId = compartmentId;
        this.contactList = contactList;
        this.tenancyInformation = tenancyInformation;
        this.ticket = ticket;
        this.incidentType = incidentType;
        this.problemType = problemType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ContactList getContactList() {
        return this.contactList;
    }

    public TenancyInformation getTenancyInformation() {
        return this.tenancyInformation;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public IncidentResourceType getIncidentType() {
        return this.incidentType;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IncidentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", contactList=").append(String.valueOf((Object)this.contactList));
        sb.append(", tenancyInformation=").append(String.valueOf((Object)this.tenancyInformation));
        sb.append(", ticket=").append(String.valueOf((Object)this.ticket));
        sb.append(", incidentType=").append(String.valueOf((Object)this.incidentType));
        sb.append(", problemType=").append(String.valueOf((Object)this.problemType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncidentSummary)) {
            return false;
        }
        IncidentSummary other = (IncidentSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.contactList, (Object)other.contactList) && Objects.equals((Object)this.tenancyInformation, (Object)other.tenancyInformation) && Objects.equals((Object)this.ticket, (Object)other.ticket) && Objects.equals((Object)this.incidentType, (Object)other.incidentType) && Objects.equals((Object)this.problemType, (Object)other.problemType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.contactList == null ? 43 : this.contactList.hashCode());
        result = result * 59 + (this.tenancyInformation == null ? 43 : this.tenancyInformation.hashCode());
        result = result * 59 + (this.ticket == null ? 43 : this.ticket.hashCode());
        result = result * 59 + (this.incidentType == null ? 43 : this.incidentType.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="contactList")
        private ContactList contactList;
        @JsonProperty(value="tenancyInformation")
        private TenancyInformation tenancyInformation;
        @JsonProperty(value="ticket")
        private Ticket ticket;
        @JsonProperty(value="incidentType")
        private IncidentResourceType incidentType;
        @JsonProperty(value="problemType")
        private ProblemType problemType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder contactList(ContactList contactList) {
            this.contactList = contactList;
            this.__explicitlySet__.add("contactList");
            return this;
        }

        public Builder tenancyInformation(TenancyInformation tenancyInformation) {
            this.tenancyInformation = tenancyInformation;
            this.__explicitlySet__.add("tenancyInformation");
            return this;
        }

        public Builder ticket(Ticket ticket) {
            this.ticket = ticket;
            this.__explicitlySet__.add("ticket");
            return this;
        }

        public Builder incidentType(IncidentResourceType incidentType) {
            this.incidentType = incidentType;
            this.__explicitlySet__.add("incidentType");
            return this;
        }

        public Builder problemType(ProblemType problemType) {
            this.problemType = problemType;
            this.__explicitlySet__.add("problemType");
            return this;
        }

        public IncidentSummary build() {
            IncidentSummary model = new IncidentSummary(this.key, this.compartmentId, this.contactList, this.tenancyInformation, this.ticket, this.incidentType, this.problemType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IncidentSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("contactList")) {
                this.contactList(model.getContactList());
            }
            if (model.wasPropertyExplicitlySet("tenancyInformation")) {
                this.tenancyInformation(model.getTenancyInformation());
            }
            if (model.wasPropertyExplicitlySet("ticket")) {
                this.ticket(model.getTicket());
            }
            if (model.wasPropertyExplicitlySet("incidentType")) {
                this.incidentType(model.getIncidentType());
            }
            if (model.wasPropertyExplicitlySet("problemType")) {
                this.problemType(model.getProblemType());
            }
            return this;
        }
    }
}

