/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.Contact;
import com.oracle.bmc.cims.model.CreateTicketDetails;
import com.oracle.bmc.cims.model.ProblemType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateIncident
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="ticket")
    private final CreateTicketDetails ticket;
    @JsonProperty(value="csi")
    private final String csi;
    @JsonProperty(value="problemType")
    private final ProblemType problemType;
    @JsonProperty(value="contacts")
    private final List<Contact> contacts;
    @JsonProperty(value="referrer")
    private final String referrer;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "ticket", "csi", "problemType", "contacts", "referrer"})
    public CreateIncident(String compartmentId, CreateTicketDetails ticket, String csi, ProblemType problemType, List<Contact> contacts, String referrer) {
        this.compartmentId = compartmentId;
        this.ticket = ticket;
        this.csi = csi;
        this.problemType = problemType;
        this.contacts = contacts;
        this.referrer = referrer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public CreateTicketDetails getTicket() {
        return this.ticket;
    }

    public String getCsi() {
        return this.csi;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateIncident(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", ticket=").append(String.valueOf((Object)this.ticket));
        sb.append(", csi=").append(String.valueOf(this.csi));
        sb.append(", problemType=").append(String.valueOf((Object)this.problemType));
        sb.append(", contacts=").append(String.valueOf(this.contacts));
        sb.append(", referrer=").append(String.valueOf(this.referrer));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIncident)) {
            return false;
        }
        CreateIncident other = (CreateIncident)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.ticket, (Object)other.ticket) && Objects.equals(this.csi, other.csi) && Objects.equals((Object)this.problemType, (Object)other.problemType) && Objects.equals(this.contacts, other.contacts) && Objects.equals(this.referrer, other.referrer) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.ticket == null ? 43 : this.ticket.hashCode());
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + (this.contacts == null ? 43 : this.contacts.hashCode());
        result = result * 59 + (this.referrer == null ? 43 : this.referrer.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="ticket")
        private CreateTicketDetails ticket;
        @JsonProperty(value="csi")
        private String csi;
        @JsonProperty(value="problemType")
        private ProblemType problemType;
        @JsonProperty(value="contacts")
        private List<Contact> contacts;
        @JsonProperty(value="referrer")
        private String referrer;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder ticket(CreateTicketDetails ticket) {
            this.ticket = ticket;
            this.__explicitlySet__.add("ticket");
            return this;
        }

        public Builder csi(String csi) {
            this.csi = csi;
            this.__explicitlySet__.add("csi");
            return this;
        }

        public Builder problemType(ProblemType problemType) {
            this.problemType = problemType;
            this.__explicitlySet__.add("problemType");
            return this;
        }

        public Builder contacts(List<Contact> contacts) {
            this.contacts = contacts;
            this.__explicitlySet__.add("contacts");
            return this;
        }

        public Builder referrer(String referrer) {
            this.referrer = referrer;
            this.__explicitlySet__.add("referrer");
            return this;
        }

        public CreateIncident build() {
            CreateIncident model = new CreateIncident(this.compartmentId, this.ticket, this.csi, this.problemType, this.contacts, this.referrer);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateIncident model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("ticket")) {
                this.ticket(model.getTicket());
            }
            if (model.wasPropertyExplicitlySet("csi")) {
                this.csi(model.getCsi());
            }
            if (model.wasPropertyExplicitlySet("problemType")) {
                this.problemType(model.getProblemType());
            }
            if (model.wasPropertyExplicitlySet("contacts")) {
                this.contacts(model.getContacts());
            }
            if (model.wasPropertyExplicitlySet("referrer")) {
                this.referrer(model.getReferrer());
            }
            return this;
        }
    }
}

