/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContextualData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="schemaVersion")
    private final String schemaVersion;
    @JsonProperty(value="payload")
    private final String payload;

    @Deprecated
    @ConstructorProperties(value={"clientId", "schemaName", "schemaVersion", "payload"})
    public ContextualData(String clientId, String schemaName, String schemaVersion, String payload) {
        this.clientId = clientId;
        this.schemaName = schemaName;
        this.schemaVersion = schemaVersion;
        this.payload = payload;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getPayload() {
        return this.payload;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContextualData(");
        sb.append("super=").append(super.toString());
        sb.append("clientId=").append(String.valueOf(this.clientId));
        sb.append(", schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", schemaVersion=").append(String.valueOf(this.schemaVersion));
        sb.append(", payload=").append(String.valueOf(this.payload));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextualData)) {
            return false;
        }
        ContextualData other = (ContextualData)((Object)o);
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.schemaVersion, other.schemaVersion) && Objects.equals(this.payload, other.payload) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.clientId == null ? 43 : this.clientId.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.schemaVersion == null ? 43 : this.schemaVersion.hashCode());
        result = result * 59 + (this.payload == null ? 43 : this.payload.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clientId")
        private String clientId;
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="schemaVersion")
        private String schemaVersion;
        @JsonProperty(value="payload")
        private String payload;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.__explicitlySet__.add("clientId");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            this.__explicitlySet__.add("schemaVersion");
            return this;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            this.__explicitlySet__.add("payload");
            return this;
        }

        public ContextualData build() {
            ContextualData model = new ContextualData(this.clientId, this.schemaName, this.schemaVersion, this.payload);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContextualData model) {
            if (model.wasPropertyExplicitlySet("clientId")) {
                this.clientId(model.getClientId());
            }
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("schemaVersion")) {
                this.schemaVersion(model.getSchemaVersion());
            }
            if (model.wasPropertyExplicitlySet("payload")) {
                this.payload(model.getPayload());
            }
            return this;
        }
    }
}

