/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims;

import com.oracle.bmc.cims.Incident;
import com.oracle.bmc.cims.model.IncidentResourceType;
import com.oracle.bmc.cims.model.IncidentSummary;
import com.oracle.bmc.cims.requests.ListIncidentResourceTypesRequest;
import com.oracle.bmc.cims.requests.ListIncidentsRequest;
import com.oracle.bmc.cims.responses.ListIncidentResourceTypesResponse;
import com.oracle.bmc.cims.responses.ListIncidentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class IncidentPaginators {
    private final Incident client;

    public IncidentPaginators(Incident client) {
        this.client = client;
    }

    public Iterable<ListIncidentResourceTypesResponse> listIncidentResourceTypesResponseIterator(final ListIncidentResourceTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIncidentResourceTypesRequest.Builder>(){

            @Override
            public ListIncidentResourceTypesRequest.Builder get() {
                return ListIncidentResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentResourceTypesResponse, String>(){

            @Override
            public String apply(ListIncidentResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder>, ListIncidentResourceTypesRequest>(){

            @Override
            public ListIncidentResourceTypesRequest apply(RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse>(){

            @Override
            public ListIncidentResourceTypesResponse apply(ListIncidentResourceTypesRequest request) {
                return IncidentPaginators.this.client.listIncidentResourceTypes(request);
            }
        });
    }

    public Iterable<IncidentResourceType> listIncidentResourceTypesRecordIterator(final ListIncidentResourceTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIncidentResourceTypesRequest.Builder>(){

            @Override
            public ListIncidentResourceTypesRequest.Builder get() {
                return ListIncidentResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentResourceTypesResponse, String>(){

            @Override
            public String apply(ListIncidentResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder>, ListIncidentResourceTypesRequest>(){

            @Override
            public ListIncidentResourceTypesRequest apply(RequestBuilderAndToken<ListIncidentResourceTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentResourceTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse>(){

            @Override
            public ListIncidentResourceTypesResponse apply(ListIncidentResourceTypesRequest request) {
                return IncidentPaginators.this.client.listIncidentResourceTypes(request);
            }
        }, (Function)new Function<ListIncidentResourceTypesResponse, List<IncidentResourceType>>(){

            @Override
            public List<IncidentResourceType> apply(ListIncidentResourceTypesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIncidentsResponse> listIncidentsResponseIterator(final ListIncidentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIncidentsRequest.Builder>(){

            @Override
            public ListIncidentsRequest.Builder get() {
                return ListIncidentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentsResponse, String>(){

            @Override
            public String apply(ListIncidentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentsRequest.Builder>, ListIncidentsRequest>(){

            @Override
            public ListIncidentsRequest apply(RequestBuilderAndToken<ListIncidentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIncidentsRequest, ListIncidentsResponse>(){

            @Override
            public ListIncidentsResponse apply(ListIncidentsRequest request) {
                return IncidentPaginators.this.client.listIncidents(request);
            }
        });
    }

    public Iterable<IncidentSummary> listIncidentsRecordIterator(final ListIncidentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIncidentsRequest.Builder>(){

            @Override
            public ListIncidentsRequest.Builder get() {
                return ListIncidentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIncidentsResponse, String>(){

            @Override
            public String apply(ListIncidentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIncidentsRequest.Builder>, ListIncidentsRequest>(){

            @Override
            public ListIncidentsRequest apply(RequestBuilderAndToken<ListIncidentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIncidentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIncidentsRequest, ListIncidentsResponse>(){

            @Override
            public ListIncidentsResponse apply(ListIncidentsRequest request) {
                return IncidentPaginators.this.client.listIncidents(request);
            }
        }, (Function)new Function<ListIncidentsResponse, List<IncidentSummary>>(){

            @Override
            public List<IncidentSummary> apply(ListIncidentsResponse response) {
                return response.getItems();
            }
        });
    }
}

