/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAssociationsRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private String compartmentId;
    private String certificatesResourceId;
    private String associatedResourceId;
    private String associationId;
    private String name;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private AssociationType associationType;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCertificatesResourceId() {
        return this.certificatesResourceId;
    }

    public String getAssociatedResourceId() {
        return this.associatedResourceId;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public String getName() {
        return this.name;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).compartmentId(this.compartmentId).certificatesResourceId(this.certificatesResourceId).associatedResourceId(this.associatedResourceId).associationId(this.associationId).name(this.name).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page).associationType(this.associationType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",certificatesResourceId=").append(String.valueOf(this.certificatesResourceId));
        sb.append(",associatedResourceId=").append(String.valueOf(this.associatedResourceId));
        sb.append(",associationId=").append(String.valueOf(this.associationId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",associationType=").append(String.valueOf((Object)this.associationType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAssociationsRequest)) {
            return false;
        }
        ListAssociationsRequest other = (ListAssociationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.certificatesResourceId, other.certificatesResourceId) && Objects.equals(this.associatedResourceId, other.associatedResourceId) && Objects.equals(this.associationId, other.associationId) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.associationType, (Object)other.associationType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.certificatesResourceId == null ? 43 : this.certificatesResourceId.hashCode());
        result = result * 59 + (this.associatedResourceId == null ? 43 : this.associatedResourceId.hashCode());
        result = result * 59 + (this.associationId == null ? 43 : this.associationId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAssociationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String compartmentId = null;
        private String certificatesResourceId = null;
        private String associatedResourceId = null;
        private String associationId = null;
        private String name = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private AssociationType associationType = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder certificatesResourceId(String certificatesResourceId) {
            this.certificatesResourceId = certificatesResourceId;
            return this;
        }

        public Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            return this;
        }

        public Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder associationType(AssociationType associationType) {
            this.associationType = associationType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAssociationsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.certificatesResourceId(o.getCertificatesResourceId());
            this.associatedResourceId(o.getAssociatedResourceId());
            this.associationId(o.getAssociationId());
            this.name(o.getName());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.associationType(o.getAssociationType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAssociationsRequest build() {
            ListAssociationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAssociationsRequest buildWithoutInvocationCallback() {
            ListAssociationsRequest request = new ListAssociationsRequest();
            request.opcRequestId = this.opcRequestId;
            request.compartmentId = this.compartmentId;
            request.certificatesResourceId = this.certificatesResourceId;
            request.associatedResourceId = this.associatedResourceId;
            request.associationId = this.associationId;
            request.name = this.name;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.associationType = this.associationType;
            return request;
        }
    }

    public static enum AssociationType implements BmcEnum
    {
        Certificate("CERTIFICATE"),
        CertificateAuthority("CERTIFICATE_AUTHORITY"),
        CaBundle("CA_BUNDLE");

        private final String value;
        private static Map<String, AssociationType> map;

        private AssociationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AssociationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AssociationType: " + key);
        }

        static {
            map = new HashMap<String, AssociationType>();
            for (AssociationType v : AssociationType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("NAME"),
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

