/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.AssociationLifecycleState;
import com.oracle.bmc.certificatesmanagement.model.AssociationType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssociationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final AssociationLifecycleState lifecycleState;
    @JsonProperty(value="certificatesResourceId")
    private final String certificatesResourceId;
    @JsonProperty(value="associatedResourceId")
    private final String associatedResourceId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="associationType")
    private final AssociationType associationType;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "timeCreated", "lifecycleState", "certificatesResourceId", "associatedResourceId", "compartmentId", "associationType"})
    public AssociationSummary(String id, String name, Date timeCreated, AssociationLifecycleState lifecycleState, String certificatesResourceId, String associatedResourceId, String compartmentId, AssociationType associationType) {
        this.id = id;
        this.name = name;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.certificatesResourceId = certificatesResourceId;
        this.associatedResourceId = associatedResourceId;
        this.compartmentId = compartmentId;
        this.associationType = associationType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public AssociationLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getCertificatesResourceId() {
        return this.certificatesResourceId;
    }

    public String getAssociatedResourceId() {
        return this.associatedResourceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", certificatesResourceId=").append(String.valueOf(this.certificatesResourceId));
        sb.append(", associatedResourceId=").append(String.valueOf(this.associatedResourceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", associationType=").append(String.valueOf((Object)this.associationType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociationSummary)) {
            return false;
        }
        AssociationSummary other = (AssociationSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.certificatesResourceId, other.certificatesResourceId) && Objects.equals(this.associatedResourceId, other.associatedResourceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.associationType, (Object)other.associationType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.certificatesResourceId == null ? 43 : this.certificatesResourceId.hashCode());
        result = result * 59 + (this.associatedResourceId == null ? 43 : this.associatedResourceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private AssociationLifecycleState lifecycleState;
        @JsonProperty(value="certificatesResourceId")
        private String certificatesResourceId;
        @JsonProperty(value="associatedResourceId")
        private String associatedResourceId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="associationType")
        private AssociationType associationType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(AssociationLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder certificatesResourceId(String certificatesResourceId) {
            this.certificatesResourceId = certificatesResourceId;
            this.__explicitlySet__.add("certificatesResourceId");
            return this;
        }

        public Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            this.__explicitlySet__.add("associatedResourceId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder associationType(AssociationType associationType) {
            this.associationType = associationType;
            this.__explicitlySet__.add("associationType");
            return this;
        }

        public AssociationSummary build() {
            AssociationSummary model = new AssociationSummary(this.id, this.name, this.timeCreated, this.lifecycleState, this.certificatesResourceId, this.associatedResourceId, this.compartmentId, this.associationType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssociationSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("certificatesResourceId")) {
                this.certificatesResourceId(model.getCertificatesResourceId());
            }
            if (model.wasPropertyExplicitlySet("associatedResourceId")) {
                this.associatedResourceId(model.getAssociatedResourceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("associationType")) {
                this.associationType(model.getAssociationType());
            }
            return this;
        }
    }
}

