/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement;

import com.oracle.bmc.certificatesmanagement.CertificatesManagement;
import com.oracle.bmc.certificatesmanagement.model.AssociationLifecycleState;
import com.oracle.bmc.certificatesmanagement.model.CaBundleLifecycleState;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityLifecycleState;
import com.oracle.bmc.certificatesmanagement.model.CertificateLifecycleState;
import com.oracle.bmc.certificatesmanagement.requests.GetAssociationRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCaBundleRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCertificateAuthorityRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCertificateRequest;
import com.oracle.bmc.certificatesmanagement.responses.GetAssociationResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCaBundleResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCertificateAuthorityResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCertificateResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class CertificatesManagementWaiters {
    private final ExecutorService executorService;
    private final CertificatesManagement client;

    public CertificatesManagementWaiters(ExecutorService executorService, CertificatesManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAssociationRequest, GetAssociationResponse> forAssociation(GetAssociationRequest request, AssociationLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAssociation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAssociationRequest, GetAssociationResponse> forAssociation(GetAssociationRequest request, AssociationLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAssociationRequest, GetAssociationResponse> forAssociation(GetAssociationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AssociationLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAssociationRequest, GetAssociationResponse> forAssociation(BmcGenericWaiter waiter, GetAssociationRequest request, AssociationLifecycleState ... targetStates) {
        final HashSet<AssociationLifecycleState> targetStatesSet = new HashSet<AssociationLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAssociationRequest, GetAssociationResponse>(){

            @Override
            public GetAssociationResponse apply(GetAssociationRequest request) {
                return CertificatesManagementWaiters.this.client.getAssociation(request);
            }
        }, (Predicate)new Predicate<GetAssociationResponse>(){

            @Override
            public boolean test(GetAssociationResponse response) {
                return targetStatesSet.contains((Object)response.getAssociation().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetCaBundleRequest, GetCaBundleResponse> forCaBundle(GetCaBundleRequest request, CaBundleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCaBundle(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCaBundleRequest, GetCaBundleResponse> forCaBundle(GetCaBundleRequest request, CaBundleLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCaBundle(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCaBundleRequest, GetCaBundleResponse> forCaBundle(GetCaBundleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CaBundleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCaBundle(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCaBundleRequest, GetCaBundleResponse> forCaBundle(BmcGenericWaiter waiter, GetCaBundleRequest request, CaBundleLifecycleState ... targetStates) {
        final HashSet<CaBundleLifecycleState> targetStatesSet = new HashSet<CaBundleLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCaBundleRequest, GetCaBundleResponse>(){

            @Override
            public GetCaBundleResponse apply(GetCaBundleRequest request) {
                return CertificatesManagementWaiters.this.client.getCaBundle(request);
            }
        }, (Predicate)new Predicate<GetCaBundleResponse>(){

            @Override
            public boolean test(GetCaBundleResponse response) {
                return targetStatesSet.contains((Object)response.getCaBundle().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CaBundleLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, CertificateLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, CertificateLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CertificateLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(BmcGenericWaiter waiter, GetCertificateRequest request, CertificateLifecycleState ... targetStates) {
        final HashSet<CertificateLifecycleState> targetStatesSet = new HashSet<CertificateLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCertificateRequest, GetCertificateResponse>(){

            @Override
            public GetCertificateResponse apply(GetCertificateRequest request) {
                return CertificatesManagementWaiters.this.client.getCertificate(request);
            }
        }, (Predicate)new Predicate<GetCertificateResponse>(){

            @Override
            public boolean test(GetCertificateResponse response) {
                return targetStatesSet.contains((Object)response.getCertificate().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CertificateLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCertificateAuthorityRequest, GetCertificateAuthorityResponse> forCertificateAuthority(GetCertificateAuthorityRequest request, CertificateAuthorityLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificateAuthority(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCertificateAuthorityRequest, GetCertificateAuthorityResponse> forCertificateAuthority(GetCertificateAuthorityRequest request, CertificateAuthorityLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCertificateAuthority(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCertificateAuthorityRequest, GetCertificateAuthorityResponse> forCertificateAuthority(GetCertificateAuthorityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CertificateAuthorityLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificateAuthority(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCertificateAuthorityRequest, GetCertificateAuthorityResponse> forCertificateAuthority(BmcGenericWaiter waiter, GetCertificateAuthorityRequest request, CertificateAuthorityLifecycleState ... targetStates) {
        final HashSet<CertificateAuthorityLifecycleState> targetStatesSet = new HashSet<CertificateAuthorityLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCertificateAuthorityRequest, GetCertificateAuthorityResponse>(){

            @Override
            public GetCertificateAuthorityResponse apply(GetCertificateAuthorityRequest request) {
                return CertificatesManagementWaiters.this.client.getCertificateAuthority(request);
            }
        }, (Predicate)new Predicate<GetCertificateAuthorityResponse>(){

            @Override
            public boolean test(GetCertificateAuthorityResponse response) {
                return targetStatesSet.contains((Object)response.getCertificateAuthority().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CertificateAuthorityLifecycleState.Deleted)), (Object)request);
    }
}

