/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.certificates.Certificates;
import com.oracle.bmc.certificates.CertificatesAsyncClient;
import com.oracle.bmc.certificates.model.CaBundle;
import com.oracle.bmc.certificates.model.CertificateAuthorityBundle;
import com.oracle.bmc.certificates.model.CertificateAuthorityBundleVersionCollection;
import com.oracle.bmc.certificates.model.CertificateBundle;
import com.oracle.bmc.certificates.model.CertificateBundleVersionCollection;
import com.oracle.bmc.certificates.requests.GetCaBundleRequest;
import com.oracle.bmc.certificates.requests.GetCertificateAuthorityBundleRequest;
import com.oracle.bmc.certificates.requests.GetCertificateBundleRequest;
import com.oracle.bmc.certificates.requests.ListCertificateAuthorityBundleVersionsRequest;
import com.oracle.bmc.certificates.requests.ListCertificateBundleVersionsRequest;
import com.oracle.bmc.certificates.responses.GetCaBundleResponse;
import com.oracle.bmc.certificates.responses.GetCertificateAuthorityBundleResponse;
import com.oracle.bmc.certificates.responses.GetCertificateBundleResponse;
import com.oracle.bmc.certificates.responses.ListCertificateAuthorityBundleVersionsResponse;
import com.oracle.bmc.certificates.responses.ListCertificateBundleVersionsResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesClient
extends BaseSyncClient
implements Certificates {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CERTIFICATES").serviceEndpointPrefix("").serviceEndpointTemplate("https://certificates.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(CertificatesAsyncClient.class);

    private CertificatesClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetCaBundleResponse getCaBundle(GetCaBundleRequest request) {
        Validate.notBlank((String)request.getCaBundleId(), (String)"caBundleId must not be blank", (Object[])new Object[0]);
        return (GetCaBundleResponse)this.clientCall(request, GetCaBundleResponse::builder).logger(LOG, "getCaBundle").serviceDetails("Certificates", "GetCaBundle", "https://docs.oracle.com/iaas/api/#/en/certificates/20210224/CaBundle/GetCaBundle").method(Method.GET).requestBuilder(GetCaBundleRequest::builder).basePath("/20210224").appendPathParam("caBundles").appendPathParam(request.getCaBundleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CaBundle.class, GetCaBundleResponse.Builder::caBundle).handleResponseHeaderString("etag", GetCaBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCaBundleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCertificateAuthorityBundleResponse getCertificateAuthorityBundle(GetCertificateAuthorityBundleRequest request) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return (GetCertificateAuthorityBundleResponse)this.clientCall(request, GetCertificateAuthorityBundleResponse::builder).logger(LOG, "getCertificateAuthorityBundle").serviceDetails("Certificates", "GetCertificateAuthorityBundle", "https://docs.oracle.com/iaas/api/#/en/certificates/20210224/CertificateAuthorityBundle/GetCertificateAuthorityBundle").method(Method.GET).requestBuilder(GetCertificateAuthorityBundleRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorityBundles").appendPathParam(request.getCertificateAuthorityId()).appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("certificateAuthorityVersionName", (Object)request.getCertificateAuthorityVersionName()).appendEnumQueryParam("stage", (BmcEnum)request.getStage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateAuthorityBundle.class, GetCertificateAuthorityBundleResponse.Builder::certificateAuthorityBundle).handleResponseHeaderString("etag", GetCertificateAuthorityBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateAuthorityBundleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCertificateBundleResponse getCertificateBundle(GetCertificateBundleRequest request) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return (GetCertificateBundleResponse)this.clientCall(request, GetCertificateBundleResponse::builder).logger(LOG, "getCertificateBundle").serviceDetails("Certificates", "GetCertificateBundle", "https://docs.oracle.com/iaas/api/#/en/certificates/20210224/CertificateBundle/GetCertificateBundle").method(Method.GET).requestBuilder(GetCertificateBundleRequest::builder).basePath("/20210224").appendPathParam("certificateBundles").appendPathParam(request.getCertificateId()).appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("certificateVersionName", (Object)request.getCertificateVersionName()).appendEnumQueryParam("stage", (BmcEnum)request.getStage()).appendEnumQueryParam("certificateBundleType", (BmcEnum)request.getCertificateBundleType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateBundle.class, GetCertificateBundleResponse.Builder::certificateBundle).handleResponseHeaderString("etag", GetCertificateBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateBundleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCertificateAuthorityBundleVersionsResponse listCertificateAuthorityBundleVersions(ListCertificateAuthorityBundleVersionsRequest request) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return (ListCertificateAuthorityBundleVersionsResponse)this.clientCall(request, ListCertificateAuthorityBundleVersionsResponse::builder).logger(LOG, "listCertificateAuthorityBundleVersions").serviceDetails("Certificates", "ListCertificateAuthorityBundleVersions", "https://docs.oracle.com/iaas/api/#/en/certificates/20210224/CertificateAuthorityBundleVersionSummary/ListCertificateAuthorityBundleVersions").method(Method.GET).requestBuilder(ListCertificateAuthorityBundleVersionsRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorityBundles").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("versions").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateAuthorityBundleVersionCollection.class, ListCertificateAuthorityBundleVersionsResponse.Builder::certificateAuthorityBundleVersionCollection).handleResponseHeaderString("opc-request-id", ListCertificateAuthorityBundleVersionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCertificateBundleVersionsResponse listCertificateBundleVersions(ListCertificateBundleVersionsRequest request) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return (ListCertificateBundleVersionsResponse)this.clientCall(request, ListCertificateBundleVersionsResponse::builder).logger(LOG, "listCertificateBundleVersions").serviceDetails("Certificates", "ListCertificateBundleVersions", "https://docs.oracle.com/iaas/api/#/en/certificates/20210224/CertificateBundleVersionSummary/ListCertificateBundleVersions").method(Method.GET).requestBuilder(ListCertificateBundleVersionsRequest::builder).basePath("/20210224").appendPathParam("certificateBundles").appendPathParam(request.getCertificateId()).appendPathParam("versions").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateBundleVersionCollection.class, ListCertificateBundleVersionsResponse.Builder::certificateBundleVersionCollection).handleResponseHeaderString("opc-request-id", ListCertificateBundleVersionsResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public CertificatesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)CertificatesClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(CertificatesClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)CertificatesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)CertificatesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)CertificatesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)CertificatesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CertificatesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CertificatesClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public CertificatesClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new CertificatesClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

