/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.budget.model.UpdateBudgetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateBudgetRequest
extends BmcRequest<UpdateBudgetDetails> {
    private String budgetId;
    private UpdateBudgetDetails updateBudgetDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getBudgetId() {
        return this.budgetId;
    }

    public UpdateBudgetDetails getUpdateBudgetDetails() {
        return this.updateBudgetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateBudgetDetails getBody$() {
        return this.updateBudgetDetails;
    }

    public Builder toBuilder() {
        return new Builder().budgetId(this.budgetId).updateBudgetDetails(this.updateBudgetDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",budgetId=").append(String.valueOf(this.budgetId));
        sb.append(",updateBudgetDetails=").append(String.valueOf((Object)this.updateBudgetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.budgetId, other.budgetId) && Objects.equals((Object)this.updateBudgetDetails, (Object)other.updateBudgetDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.budgetId == null ? 43 : this.budgetId.hashCode());
        result = result * 59 + (this.updateBudgetDetails == null ? 43 : this.updateBudgetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateBudgetRequest, UpdateBudgetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String budgetId = null;
        private UpdateBudgetDetails updateBudgetDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder updateBudgetDetails(UpdateBudgetDetails updateBudgetDetails) {
            this.updateBudgetDetails = updateBudgetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateBudgetRequest o) {
            this.budgetId(o.getBudgetId());
            this.updateBudgetDetails(o.getUpdateBudgetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateBudgetRequest build() {
            UpdateBudgetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateBudgetDetails body) {
            this.updateBudgetDetails(body);
            return this;
        }

        public UpdateBudgetRequest buildWithoutInvocationCallback() {
            UpdateBudgetRequest request = new UpdateBudgetRequest();
            request.budgetId = this.budgetId;
            request.updateBudgetDetails = this.updateBudgetDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

